/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.progressbar;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.progressbar.HorizontalProgressBar;
import org.eclipse.reddeer.swt.impl.progressbar.IndeterminateProgressBar;
import org.eclipse.reddeer.swt.impl.progressbar.VerticalProgressBar;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class ProgressBarTest
extends SWTLayerTestCase {
    private ProgressBar pbVertical;
    private ProgressBar pbHorizontal;

    @Override
    protected void createControls(Shell shell) {
        this.pbVertical = new ProgressBar((Composite)shell, 512);
        this.pbVertical.setMinimum(0);
        this.pbVertical.setMaximum(100);
        this.pbVertical.setSelection(15);
        this.pbVertical.setSelection(50);
        this.pbHorizontal = new ProgressBar((Composite)shell, 256);
        this.pbHorizontal.setMaximum(200);
        this.pbHorizontal.setMinimum(100);
        this.pbHorizontal.setSelection(150);
        new ProgressBar((Composite)shell, 258);
    }

    @Test
    public void verticalProgressBarTest() {
        VerticalProgressBar vpb = new VerticalProgressBar();
        new VerticalProgressBar(0);
        Assert.assertEquals((long)0L, (long)vpb.getMinimum());
        Assert.assertEquals((long)100L, (long)vpb.getMaximum());
        Assert.assertEquals((long)50L, (long)vpb.getSelection());
        Assert.assertEquals((long)0L, (long)vpb.getState());
    }

    @Test(expected=CoreLayerException.class)
    public void nonExistingVerticalProgressBarTest() {
        new VerticalProgressBar(1);
    }

    @Test
    public void horizontalProgressBarTest() {
        HorizontalProgressBar hpb = new HorizontalProgressBar();
        new HorizontalProgressBar(0);
        new HorizontalProgressBar(1);
        Assert.assertEquals((long)100L, (long)hpb.getMinimum());
        Assert.assertEquals((long)200L, (long)hpb.getMaximum());
        Assert.assertEquals((long)150L, (long)hpb.getSelection());
    }

    @Test(expected=CoreLayerException.class)
    public void nonExistinghorizontalProgressBarTest() {
        new HorizontalProgressBar(2);
    }

    @Test
    public void IndeterminateProgressBarTest() {
        new IndeterminateProgressBar();
        new IndeterminateProgressBar(0);
    }

    @Test(expected=CoreLayerException.class)
    public void noonExistingIndeterminateProgressBarTest() {
        new IndeterminateProgressBar(1);
    }
}

