/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.properties;

import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RedDeerPropertiesTest {
    private static String relativeScreenshotDirectoryValue;
    private static boolean relativeScreenshotDirectoryDefined;
    private static String timePeriodFactor;
    private static boolean timePeriodFactorDefined;

    static {
        relativeScreenshotDirectoryDefined = false;
        timePeriodFactorDefined = false;
    }

    @BeforeClass
    public static void setup() {
        if (System.getProperties().containsKey(RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getName())) {
            relativeScreenshotDirectoryValue = RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getValue();
            relativeScreenshotDirectoryDefined = true;
        }
        if (System.getProperties().containsKey(RedDeerProperties.TIME_PERIOD_FACTOR.getName())) {
            timePeriodFactor = RedDeerProperties.TIME_PERIOD_FACTOR.getValue();
            timePeriodFactorDefined = true;
        }
    }

    @AfterClass
    public static void cleanup() {
        if (relativeScreenshotDirectoryDefined) {
            System.setProperty(RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getName(), relativeScreenshotDirectoryValue);
        } else {
            System.clearProperty(RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getName());
        }
        if (timePeriodFactorDefined) {
            System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), timePeriodFactor);
        } else {
            System.clearProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName());
        }
    }

    @Test(expected=RedDeerException.class)
    public void getByName_nonExisting() {
        RedDeerProperties.getByName((String)"abc");
    }

    @Test
    public void getSystemValue() {
        System.setProperty(RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getName(), "abc");
        Assert.assertEquals((Object)"abc", (Object)RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getValue());
    }

    @Test
    public void getSystemValue_float() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "0.5");
        Assert.assertEquals((Object)"0.5", (Object)RedDeerProperties.TIME_PERIOD_FACTOR.getValue());
    }

    @Test(expected=RedDeerException.class)
    public void getSystemValue_float_fail() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "abc");
        RedDeerProperties.TIME_PERIOD_FACTOR.getValue();
    }

    @Test(expected=RedDeerException.class)
    public void getBooleanSystemValue_textProperty() {
        System.setProperty(RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getName(), "abc");
        Assert.assertFalse((boolean)RedDeerProperties.RELATIVE_SCREENSHOT_DIRECTORY.getBooleanValue());
    }

    @Test
    public void getFloatSystemValue() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "0.5");
        MatcherAssert.assertThat((Object)Float.valueOf(RedDeerProperties.TIME_PERIOD_FACTOR.getFloatValue()), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.5f)));
    }

    @Test(expected=RedDeerException.class)
    public void getFloatSystemValue_textProperty() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "abc");
        RedDeerProperties.TIME_PERIOD_FACTOR.getFloatValue();
    }
}

