/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.button;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DataBindingRadioButtonTest
extends SWTLayerTestCase {
    private static final String RADIO_BUTTON_LABEL_PREFIX = "RADIO-BUTTON";
    private static final int NUM_BUTTONS = 3;
    private static final int COLUMNS = 3;
    private static final int INDENT = 40;
    private DataBindingContext dbc;
    private TestPageModel model;

    @Override
    protected void createControls(Shell shell) {
        shell.setLayout((Layout)new GridLayout(3, true));
        this.dbc = new DataBindingContext();
        this.model = new TestPageModel();
        Group group = new Group((Composite)shell, 0);
        group.setText("Radio Group with Names");
        GridLayoutFactory.fillDefaults().applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
        SelectObservableValue selectedRadioButtonObservable = new SelectObservableValue();
        Button buttonA = new Button((Composite)group, 16);
        buttonA.setText("RADIO-BUTTONA");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)buttonA);
        selectedRadioButtonObservable.addOption((Object)"Selected: A", (IObservableValue)WidgetProperties.selection().observe((Widget)buttonA));
        Label labelA = new Label((Composite)group, 0);
        labelA.setText("Label A");
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)labelA);
        Text textA = new Text((Composite)group, 2048);
        textA.setText("Text A");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textA);
        Button buttonB = new Button((Composite)group, 16);
        buttonB.setText("RADIO-BUTTONB");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)buttonB);
        selectedRadioButtonObservable.addOption((Object)"Selected: B", (IObservableValue)WidgetProperties.selection().observe((Widget)buttonB));
        Label labelB = new Label((Composite)group, 0);
        labelB.setText("Label B");
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)labelB);
        Text textB = new Text((Composite)group, 2048);
        textB.setText("Text B");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textB);
        Button buttonC = new Button((Composite)group, 16);
        buttonC.setText("RADIO-BUTTONC");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)buttonC);
        selectedRadioButtonObservable.addOption((Object)"Selected: C", (IObservableValue)WidgetProperties.selection().observe((Widget)buttonC));
        Label labelC = new Label((Composite)group, 0);
        labelC.setText("Label C");
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)labelC);
        Text textC = new Text((Composite)group, 2048);
        textC.setText("Text C");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textC);
        Label label = new Label((Composite)shell, 0);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        ISWTObservableValue labelTextObservable = WidgetProperties.text().observe((Widget)label);
        IObservableValue buttonAModeModelObservable = BeanProperties.value(TestPageModel.class, (String)"buttonABindingMode").observe((Object)this.model);
        IObservableValue buttonATextModelObservable = BeanProperties.value(TestPageModel.class, (String)"buttonAText").observe((Object)this.model);
        IObservableValue buttonBModeModelObservable = BeanProperties.value(TestPageModel.class, (String)"buttonBBindingMode").observe((Object)this.model);
        IObservableValue buttonBTextModelObservable = BeanProperties.value(TestPageModel.class, (String)"buttonBText").observe((Object)this.model);
        IObservableValue buttonCModeModelObservable = BeanProperties.value(TestPageModel.class, (String)"buttonCBindingMode").observe((Object)this.model);
        IObservableValue buttonCTextModelObservable = BeanProperties.value(TestPageModel.class, (String)"buttonCText").observe((Object)this.model);
        Control[] buttonAControls = new Control[]{textA, labelA};
        Control[] buttonBControls = new Control[]{textB, labelB};
        Control[] buttonCControls = new Control[]{textC, labelC};
        buttonAModeModelObservable.addChangeListener(this.onButtonASelection(buttonAControls));
        buttonBModeModelObservable.addChangeListener(this.onButtonBSelection(buttonBControls));
        buttonCModeModelObservable.addChangeListener(this.onButtonCSelection(buttonCControls));
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)buttonA), buttonAModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textA), buttonATextModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)buttonB), buttonBModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textB), buttonBTextModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)buttonC), buttonCModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textC), buttonCTextModelObservable);
        this.dbc.bindValue((IObservableValue)selectedRadioButtonObservable, (IObservableValue)labelTextObservable);
        this.setDefaultSettings();
        this.updateWidgetsState(buttonAControls, buttonBControls, buttonCControls);
    }

    private void setDefaultSettings() {
        this.model.setButtonABindingMode(true);
    }

    private IChangeListener onButtonASelection(final Control ... controls) {
        return new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DataBindingRadioButtonTest.this.setWidgetsEnabled(DataBindingRadioButtonTest.this.model.isButtonABindingMode(), controls);
            }
        };
    }

    private IChangeListener onButtonBSelection(final Control ... controls) {
        return new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DataBindingRadioButtonTest.this.setWidgetsEnabled(DataBindingRadioButtonTest.this.model.isButtonBBindingMode(), controls);
            }
        };
    }

    private IChangeListener onButtonCSelection(final Control ... controls) {
        return new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DataBindingRadioButtonTest.this.setWidgetsEnabled(DataBindingRadioButtonTest.this.model.isButtonCBindingMode(), controls);
            }
        };
    }

    private void setWidgetsEnabled(boolean enabled, Control ... controls) {
        Control control;
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
        if (enabled) {
            controlArray = controls;
            n = controls.length;
            n2 = 0;
            while (n2 < n) {
                control = controlArray[n2];
                if (control instanceof org.eclipse.reddeer.swt.api.Text) {
                    control.setFocus();
                    break;
                }
                ++n2;
            }
        }
    }

    private void updateWidgetsState(Control[] buttonAControls, Control[] buttonBControls, Control[] buttonCControls) {
        this.setWidgetsEnabled(this.model.isButtonABindingMode(), buttonAControls);
        this.setWidgetsEnabled(this.model.isButtonBBindingMode(), buttonBControls);
        this.setWidgetsEnabled(this.model.isButtonCBindingMode(), buttonCControls);
    }

    @Test
    public void clickOnRadioButtons() {
        RadioButton radioButtonA = new RadioButton(0, new Matcher[0]);
        RadioButton radioButtonB = new RadioButton(1, new Matcher[0]);
        RadioButton radioButtonC = new RadioButton(2, new Matcher[0]);
        LabeledText textA = new LabeledText("Label A");
        LabeledText textB = new LabeledText("Label B");
        LabeledText textC = new LabeledText("Label C");
        Assert.assertTrue((String)("Radio Button " + radioButtonA.getText() + " is not selected"), (boolean)radioButtonA.isSelected());
        Assert.assertTrue((String)"Labeled text textA is not active", (boolean)textA.isEnabled());
        Assert.assertFalse((String)"Labeled text textB is active (but it should be deactivated!)", (boolean)textB.isEnabled());
        Assert.assertFalse((String)"Labeled text textC is active (but it should be deactivated!)", (boolean)textC.isEnabled());
        radioButtonB.click();
        Assert.assertTrue((String)("Radio Button " + radioButtonB.getText() + " is not selected"), (boolean)radioButtonB.isSelected());
        Assert.assertFalse((String)"Labeled text textA is active (but it should be deactivated!)", (boolean)textA.isEnabled());
        Assert.assertTrue((String)"Labeled text textB is not active", (boolean)textB.isEnabled());
        Assert.assertFalse((String)"Labeled text textC is active (but it should be deactivated!)", (boolean)textC.isEnabled());
        radioButtonC.click();
        Assert.assertTrue((String)("Radio Button " + radioButtonC.getText() + " is not selected"), (boolean)radioButtonC.isSelected());
        Assert.assertFalse((String)"Labeled text textA is active (but it should be deactivated!)", (boolean)textA.isEnabled());
        Assert.assertFalse((String)"Labeled text textB is active (but it should be deactivated!)", (boolean)textB.isEnabled());
        Assert.assertTrue((String)"Labeled text textC is not active", (boolean)textC.isEnabled());
    }

    private class TestPageModel {
        private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        public static final String BUTTON_A_BINDING_MODE = "buttonABindingMode";
        public static final String BUTTON_B_BINDING_MODE = "buttonBBindingMode";
        public static final String BUTTON_C_BINDING_MODE = "buttonCBindingMode";
        public static final String BUTTON_A_TEXT = "buttonAText";
        public static final String BUTTON_B_TEXT = "buttonBText";
        public static final String BUTTON_C_TEXT = "buttonCText";
        private boolean buttonABindingMode = false;
        private boolean buttonBBindingMode = false;
        private boolean buttonCBindingMode = false;
        private String buttonAText = null;
        private String buttonBText = null;
        private String buttonCText = null;

        private TestPageModel() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }

        public boolean isButtonABindingMode() {
            return this.buttonABindingMode;
        }

        public boolean isButtonBBindingMode() {
            return this.buttonBBindingMode;
        }

        public boolean isButtonCBindingMode() {
            return this.buttonCBindingMode;
        }

        public void setButtonABindingMode(boolean buttonABindingMode) {
            this.buttonABindingMode = buttonABindingMode;
            this.firePropertyChange(BUTTON_A_BINDING_MODE, this.buttonABindingMode, this.buttonABindingMode);
        }

        public void setButtonBBindingMode(boolean buttonBBindingMode) {
            this.buttonBBindingMode = buttonBBindingMode;
            this.firePropertyChange(BUTTON_B_BINDING_MODE, this.buttonBBindingMode, this.buttonBBindingMode);
        }

        public void setButtonCBindingMode(boolean buttonCBindingMode) {
            this.buttonCBindingMode = buttonCBindingMode;
            this.firePropertyChange(BUTTON_C_BINDING_MODE, this.buttonCBindingMode, this.buttonCBindingMode);
        }

        public String getButtonAText() {
            return this.buttonAText;
        }

        public void setButtonAText(String buttonAText) {
            this.buttonAText = buttonAText;
            this.firePropertyChange(BUTTON_A_TEXT, this.buttonAText, this.buttonAText);
        }

        public String getButtonBText() {
            return this.buttonBText;
        }

        public void setButtonBText(String buttonBText) {
            this.buttonBText = buttonBText;
            this.firePropertyChange(BUTTON_B_TEXT, this.buttonBText, this.buttonBText);
        }

        public String getButtonCText() {
            return this.buttonCText;
        }

        public void setButtonCText(String buttonCText) {
            this.buttonCText = buttonCText;
            this.firePropertyChange(BUTTON_C_TEXT, this.buttonCText, this.buttonCText);
        }
    }
}

