/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.link;

import java.util.List;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.link.AnchorLink;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.reddeer.swt.test.impl.link.LinkTestUtils;
import org.eclipse.reddeer.swt.test.utils.TextTestUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class AnchorLinkTest
extends SWTLayerTestCase {
    @Override
    protected void createControls(Shell parent) {
        final Text text = TextTestUtils.createText((Composite)parent, "");
        Link link1 = LinkTestUtils.createLink(parent, "This is a <a href=\"test1\">link1</a>");
        link1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText(e.text);
            }
        });
        Link link2 = LinkTestUtils.createLink(parent, "This is another <A>link2</A> with two <a href=\"test2\">links</a>");
        link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText(e.text);
            }
        });
        Link link3 = LinkTestUtils.createLink(parent, "Link with same texts <a href=\"same1\">same</a><a href=\"same2\">same</a>");
        link3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText(e.text);
            }
        });
    }

    @Test
    public void stringConstructorTest() {
        AnchorLink link1 = new AnchorLink("link1");
        AnchorLink link2 = new AnchorLink("link2");
        Assert.assertNotNull((Object)link1);
        Assert.assertNotNull((Object)link2);
    }

    @Test
    public void getTextTest() {
        String text1 = new AnchorLink("link1").getText();
        String text2 = new AnchorLink("link2").getText();
        Assert.assertEquals((Object)"This is a link1", (Object)text1);
        Assert.assertEquals((Object)"This is another link2 with two links", (Object)text2);
    }

    @Test
    public void getHrefTextsTest() {
        List text1 = new AnchorLink("link1").getAnchorTexts();
        List text2 = new AnchorLink("link2").getAnchorTexts();
        Assert.assertEquals((long)1L, (long)text1.size());
        Assert.assertEquals((long)2L, (long)text2.size());
        Assert.assertEquals((Object)"link1", text1.get(0));
        Assert.assertEquals((Object)"link2", text2.get(0));
        Assert.assertEquals((Object)"links", text2.get(1));
    }

    @Test
    public void clickTest() {
        DefaultText text = new DefaultText(0, new Matcher[0]);
        Assert.assertEquals((Object)"", (Object)text.getText());
        new AnchorLink("link1").click("link1");
        Assert.assertEquals((Object)"test1", (Object)text.getText());
        new AnchorLink("link2").click("link2");
        Assert.assertEquals((Object)"link2", (Object)text.getText());
        new AnchorLink("link2").click("links");
        Assert.assertEquals((Object)"test2", (Object)text.getText());
        new AnchorLink("link1").click();
        Assert.assertEquals((Object)"test1", (Object)text.getText());
        new AnchorLink("links").click();
        Assert.assertEquals((Object)"link2", (Object)text.getText());
        new AnchorLink("links").click(1);
        Assert.assertEquals((Object)"test2", (Object)text.getText());
    }

    @Test(expected=CoreLayerException.class)
    public void clickWrongTextTest() {
        new AnchorLink("link1").click("wrongText");
    }

    @Test(expected=CoreLayerException.class)
    public void clickWrongIndexTest() {
        new AnchorLink("link1").click(1);
    }

    @Test
    public void sameAnchorTextTest() {
        DefaultText text = new DefaultText(0, new Matcher[0]);
        AnchorLink link = new AnchorLink("same");
        link.click("same", 0);
        Assert.assertEquals((Object)"same1", (Object)text.getText());
        link.click("same", 1);
        Assert.assertEquals((Object)"same2", (Object)text.getText());
    }
}

