/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.requirement;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.execution.PriorityComparator;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;

public class Requirements
implements Requirement<Annotation>,
Iterable<Requirement<?>> {
    private List<Requirement<?>> requirements;
    private Class<?> clazz;
    private String configID;
    private Logger log = Logger.getLogger(Requirements.class);

    public Requirements(List<Requirement<?>> requirements, Class<?> clazz, String configID) {
        if (requirements == null) {
            throw new IllegalArgumentException("The requirements list was null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The class containing requirements is null");
        }
        requirements.sort(new PriorityComparator());
        this.requirements = requirements;
        this.clazz = clazz;
        this.configID = configID;
    }

    @Override
    public Iterator<Requirement<?>> iterator() {
        return this.requirements.iterator();
    }

    public int size() {
        return this.requirements.size();
    }

    @Override
    public void fulfill() {
        this.runSafely(Requirement::fulfill);
    }

    @Override
    public void cleanUp() {
        this.runSafely(Requirement::cleanUp);
    }

    @Override
    public void runBefore() {
        this.runSafely(Requirement::runBefore);
    }

    @Override
    public void runBeforeClass() {
        this.runSafely(Requirement::runBeforeClass);
    }

    @Override
    public void runAfter() {
        this.runSafely(Requirement::runAfter);
    }

    @Override
    public void runAfterClass() {
        this.runSafely(Requirement::runAfterClass);
    }

    private void runSafely(Consumer<Requirement<?>> run) {
        this.requirements.forEach(requirement -> this.runSafely(run, (Requirement<?>)requirement));
    }

    private void runSafely(Consumer<Requirement<?>> run, Requirement<?> requirement) {
        try {
            run.accept(requirement);
        }
        catch (Throwable t) {
            this.handleException(t, requirement);
            throw t;
        }
    }

    @Override
    public void setDeclaration(Annotation declaration) {
        throw new IllegalStateException("This method should never be called on wrapper object");
    }

    private void handleException(Throwable ex, Requirement<?> r) {
        if (ScreenshotCapturer.shouldCaptureScreenshotOnException(ex)) {
            ScreenshotCapturer screenshotCapturer = ScreenshotCapturer.getInstance();
            try {
                screenshotCapturer.captureScreenshotOnFailure(this.configID, ScreenshotCapturer.getScreenshotFileName(this.clazz, null, r.getClass().getSimpleName()));
            }
            catch (CaptureScreenshotException e) {
                e.printInfo(this.log);
            }
        }
    }

    @Override
    public Annotation getDeclaration() {
        throw new IllegalStateException("This method should never be called on wrapper object");
    }
}

