/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.test.condition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.core.condition.WidgetIsDisposed;
import org.eclipse.reddeer.core.test.condition.shells.TableShell;
import org.eclipse.reddeer.core.test.condition.shells.TreeShell;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class WidgetIsDisposedTest {
    private TreeShell tree;
    private TableShell table;

    @Test
    public void testDisposedTree() {
        this.tree = new TreeShell();
        List<WidgetIsDisposed> disposeChecks = this.getTreeDisposeChecks();
        this.assertNotDisposed(disposeChecks);
        this.closeShells();
        this.assertDisposed(disposeChecks);
    }

    @Test
    public void testDisposedTable() {
        this.table = new TableShell();
        List<WidgetIsDisposed> disposeChecks = this.getTableDisposeChecks();
        this.assertNotDisposed(disposeChecks);
        this.closeShells();
        this.assertDisposed(disposeChecks);
    }

    @After
    public void closeShells() {
        if (this.tree != null) {
            this.tree.close();
            this.tree = null;
        }
        if (this.table != null) {
            this.table.close();
            this.table = null;
        }
    }

    private List<WidgetIsDisposed> getTreeDisposeChecks() {
        ArrayList<WidgetIsDisposed> disposeChecks = new ArrayList<WidgetIsDisposed>();
        disposeChecks.add(new WidgetIsDisposed(new DefaultShell().getSWTWidget()));
        for (TreeItem treeItem : this.tree.dfs()) {
            disposeChecks.add(new WidgetIsDisposed(treeItem.getSWTWidget()));
        }
        return disposeChecks;
    }

    private List<WidgetIsDisposed> getTableDisposeChecks() {
        ArrayList<WidgetIsDisposed> disposeChecks = new ArrayList<WidgetIsDisposed>();
        disposeChecks.add(new WidgetIsDisposed(new DefaultShell().getSWTWidget()));
        for (TableItem tableItem : this.table.getFirstTwentyItems()) {
            disposeChecks.add(new WidgetIsDisposed(tableItem.getSWTWidget()));
        }
        return disposeChecks;
    }

    private void assertDisposed(List<WidgetIsDisposed> disposeChecks) {
        for (WidgetIsDisposed disposeCheck : disposeChecks) {
            Assert.assertTrue((String)"Fail, widget is not disposed!", (boolean)disposeCheck.test());
        }
    }

    private void assertNotDisposed(List<WidgetIsDisposed> disposeChecks) {
        for (WidgetIsDisposed disposeCheck : disposeChecks) {
            Assert.assertFalse((String)"Fail, widget is disposed!", (boolean)disposeCheck.test());
        }
    }
}

