/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.equinox.security.ui;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.ChangePasswordWizardDialog;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.DescriptiveStorageLoginDialog;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.DescriptiveStorageNewDialog;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.reddeer.eclipse.equinox.security.ui.storage.StoragePreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.TabFolder;
import org.eclipse.reddeer.swt.api.TabItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.tab.DefaultTabItem;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class StoragePreferencePageTest {
    private WorkbenchPreferenceDialog workbenchPreferenceDialog = new WorkbenchPreferenceDialog();

    @Before
    public void openWorkbenchPreferenceDialog() {
        this.workbenchPreferenceDialog.open();
    }

    @Test
    public void openStoragePreferencePageTest() {
        this.workbenchPreferenceDialog.select((PreferencePage)new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog));
        Assert.assertTrue((String)"Secure storage preference page hasnot been opened.", (boolean)"Secure Storage".equals(this.workbenchPreferenceDialog.getPageName()));
    }

    @Test
    public void selectDifferentTabsOnPreferencePageTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        TabFolder tabFolder = new DefaultTabItem("Contents").getTabFolder();
        storagePage.selectContentTab();
        Assert.assertTrue((tabFolder.getSelection().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Contents", (Object)((TabItem)tabFolder.getSelection().get(0)).getText());
        storagePage.selectAdvancedTab();
        Assert.assertTrue((tabFolder.getSelection().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Advanced", (Object)((TabItem)tabFolder.getSelection().get(0)).getText());
        storagePage.selectPasswordsTab();
        Assert.assertTrue((tabFolder.getSelection().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Password", (Object)((TabItem)tabFolder.getSelection().get(0)).getText());
    }

    @Test
    public void getMasterPasswordProvidersTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        Assert.assertTrue((String)"Obtained number of master password providers is not same as in the table on the Password tab", (storagePage.getMasterPasswordProviders().size() == new DefaultTable(0, new Matcher[0]).getItems().size() ? 1 : 0) != 0);
    }

    @Test
    public void getStorageLocationTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        Assert.assertFalse((boolean)storagePage.getStorageLocation().isEmpty());
    }

    @Test
    public void getEncryptionAlgorithmTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        String algorithm = storagePage.getEncryptionAlgorithm();
        Assert.assertNotNull((Object)algorithm);
        Assert.assertEquals((Object)new DefaultCombo().getSelection(), (Object)algorithm);
    }

    @Test
    public void getAvailableEncryptionAlgorithmsTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        List availableAlgorithms = storagePage.getAvailableEncryptionAlgorithms();
        Assert.assertFalse((boolean)availableAlgorithms.isEmpty());
        Assert.assertTrue((new DefaultCombo().getItems().size() == availableAlgorithms.size() ? 1 : 0) != 0);
    }

    @Test
    public void availableAlgorithmsContainsCurrentAlgorithmTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        List availableAlgorithms = storagePage.getAvailableEncryptionAlgorithms();
        Assert.assertTrue((boolean)availableAlgorithms.contains(storagePage.getEncryptionAlgorithm()));
    }

    @Test
    public void setEncryptionAlgorithmTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        List availableAlgorithms = storagePage.getAvailableEncryptionAlgorithms();
        String lastAlgorithm = (String)availableAlgorithms.get(availableAlgorithms.size() - 1);
        storagePage.setEncryptionAlgorithm(lastAlgorithm);
        Assert.assertEquals((Object)lastAlgorithm, (Object)storagePage.getEncryptionAlgorithm());
    }

    @After
    public void closeWorkbenchPreferenceDialog() {
        this.workbenchPreferenceDialog.cancel();
    }

    @Test
    @Ignore
    public void recoverMasterPasswordTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        PasswordRecoveryDialog recoveryDialog = storagePage.recoverMasterPassword();
        Assert.assertTrue((boolean)new ShellIsAvailable("Password Recovery").test());
        recoveryDialog.answerFirstQuestion("answer1");
        recoveryDialog.answerSecondQuestion("answer2");
        Assert.assertTrue((boolean)new OkButton().isEnabled());
        recoveryDialog.cancel();
    }

    @Test
    @Ignore
    public void changeMasterPasswordTest() {
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)this.workbenchPreferenceDialog);
        this.workbenchPreferenceDialog.select((PreferencePage)storagePage);
        ChangePasswordWizardDialog changePassDialog = storagePage.changeMasterPassword();
        Assert.assertTrue((boolean)new ShellIsAvailable(changePassDialog.getShell()).test());
        changePassDialog.next();
        DescriptiveStorageLoginDialog oldPasswordDialog = new DescriptiveStorageLoginDialog();
        Assert.assertTrue((boolean)new ShellIsAvailable(oldPasswordDialog.getShell()).test());
        oldPasswordDialog.setPassword("oldPassword");
        oldPasswordDialog.ok();
        changePassDialog.next();
        DescriptiveStorageNewDialog newPasswordDialog = new DescriptiveStorageNewDialog();
        Assert.assertTrue((boolean)new ShellIsAvailable(newPasswordDialog.getShell()).test());
        newPasswordDialog.setNewPassword("newPassword");
        newPasswordDialog.ok();
        changePassDialog.fillHints("q1", "q2", "a1", "a2");
        changePassDialog.finish();
    }
}

