/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServerModule;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ModifyModulesDialogTest
extends ServersViewTestCase {
    private static final String SERVER = "Server ABC";
    private static Server server;

    @BeforeClass
    public static void createProjects() {
        ModifyModulesDialogTest.importProjects();
        ModifyModulesDialogTest.createServer(SERVER);
        server = ModifyModulesDialogTest.getServersView().getServer(SERVER);
    }

    @After
    public void removeModules() {
        List modules = server.getModules();
        for (ServerModule module : modules) {
            module.remove();
        }
    }

    @AfterClass
    public static void removeProjects() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        for (DefaultProject project : explorer.getProjects()) {
            DeleteUtils.forceProjectDeletion((DefaultProject)project, (boolean)true);
        }
    }

    @Test
    public void addAll_removeTwo() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        dialog.finish();
        List<String> expectedBefore = Arrays.asList("server-project", "server-project-2", "server-project-3");
        List modules = server.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)3));
        modules.stream().forEach(mod -> Assert.assertTrue((boolean)expectedBefore.contains(mod.getLabel().getName())));
        dialog = server.addAndRemoveModules();
        page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.remove(new String[]{"server-project", "server-project-3"});
        dialog.finish();
        modules = server.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-2"));
    }

    @Test
    public void addTwo_removeAll() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.add(new String[]{"server-project", "server-project-3"});
        dialog.finish();
        List modules = server.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project"));
        MatcherAssert.assertThat((Object)((ServerModule)modules.get(1)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-3"));
        dialog = server.addAndRemoveModules();
        page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.removeAll();
        dialog.finish();
        modules = server.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testRemoveConfiguredModules() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.add(new String[]{"server-project", "server-project-3"});
        if (!page.getConfiguredModules().isEmpty()) {
            page.removeAll();
        }
        dialog.finish();
    }

    @Test
    public void getAvailableModules() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        List availableModules = page.getAvailableModules();
        dialog.cancel();
        MatcherAssert.assertThat((Object)availableModules.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((String)availableModules.get(0)), (Matcher)CoreMatchers.is((Object)"server-project"));
        MatcherAssert.assertThat((Object)((String)availableModules.get(1)), (Matcher)CoreMatchers.is((Object)"server-project-2"));
        MatcherAssert.assertThat((Object)((String)availableModules.get(2)), (Matcher)CoreMatchers.is((Object)"server-project-3"));
    }

    @Test
    public void getConfiguredModules() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        List configuredModules = page.getConfiguredModules();
        dialog.cancel();
        MatcherAssert.assertThat((Object)configuredModules.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((String)configuredModules.get(0)), (Matcher)CoreMatchers.is((Object)"server-project"));
        MatcherAssert.assertThat((Object)((String)configuredModules.get(1)), (Matcher)CoreMatchers.is((Object)"server-project-2"));
        MatcherAssert.assertThat((Object)((String)configuredModules.get(2)), (Matcher)CoreMatchers.is((Object)"server-project-3"));
    }

    @Test
    public void testSwitchingOffPublishingChanges() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.add(new String[]{"server-project"});
        page.togglePublishChanges(false);
        dialog.finish();
        List configuredModules = server.getModules();
        MatcherAssert.assertThat((Object)configuredModules.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ServerModule)configuredModules.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project"));
        MatcherAssert.assertThat((Object)((ServerModule)configuredModules.get(0)).getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.NONE));
    }
}

