/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.preferences;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.TreeItemTextMatcher;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tab.DefaultTabItem;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TreeItem;
import org.hamcrest.Matcher;

public class BuildPathsPropertyPage
extends PropertyPage {
    public static final String NAME = "Java Build Path";
    public static final String CLASSPATH = "Classpath";
    public static final String MODULEPATH = "Modulepath";
    private static final Logger log = Logger.getLogger(BuildPathsPropertyPage.class);

    public BuildPathsPropertyPage(ReferencedComposite referencedComposite) {
        super(referencedComposite, NAME);
    }

    public BuildPathsPropertyPage activateSourceTab() {
        try {
            new DefaultCTabItem((ReferencedComposite)this, "Source").activate();
        }
        catch (CoreLayerException coreLayerException) {
            new DefaultTabItem((ReferencedComposite)this, "Source").activate();
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        return this;
    }

    public BuildPathsPropertyPage activateProjectsTab() {
        try {
            new DefaultCTabItem((ReferencedComposite)this, "Projects").activate();
        }
        catch (CoreLayerException coreLayerException) {
            new DefaultTabItem((ReferencedComposite)this, "Projects").activate();
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        return this;
    }

    public BuildPathsPropertyPage activateLibrariesTab() {
        try {
            new DefaultCTabItem((ReferencedComposite)this, "Libraries").activate();
        }
        catch (CoreLayerException coreLayerException) {
            new DefaultTabItem((ReferencedComposite)this, "Libraries").activate();
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        return this;
    }

    public BuildPathsPropertyPage activateOrderAndExportTab() {
        try {
            new DefaultCTabItem((ReferencedComposite)this, "Order and Export").activate();
        }
        catch (CoreLayerException coreLayerException) {
            new DefaultTabItem((ReferencedComposite)this, "Order and Export").activate();
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        return this;
    }

    public String addVariable(String name, String value, boolean overwriteIfExists) {
        log.info("Adding variable: " + name + "=" + value);
        this.activateLibrariesTab();
        return this.addVariableShared(name, value, overwriteIfExists);
    }

    private String addVariableShared(String name, String value, boolean overwriteIfExists) {
        new PushButton((ReferencedComposite)this, "Add Variable...").click();
        DefaultShell variableEntryShell = new DefaultShell("New Variable Classpath Entry");
        new PushButton((ReferencedComposite)variableEntryShell, "Configure Variables...").click();
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        preferencesDialog.open();
        String result = new ClasspathVariablesPreferencePage((ReferencedComposite)preferencesDialog).addVariable(name, value, overwriteIfExists);
        preferencesDialog.ok();
        new OkButton((ReferencedComposite)variableEntryShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)variableEntryShell));
        new WaitWhile((WaitCondition)new JobIsRunning());
        new PushButton((ReferencedComposite)this, "Apply").click();
        new WaitWhile((WaitCondition)new JobIsRunning());
        return result;
    }

    public String addVariableOnClasspath(String name, String value, boolean overwriteIfExists) {
        log.info("Adding variable on Classpath: " + name + "=" + value);
        this.activateLibrariesTab();
        this.getLibraryTree().getItem(new String[]{CLASSPATH}).select();
        return this.addVariableShared(name, value, overwriteIfExists);
    }

    public String addVariableOnModulepath(String name, String value, boolean overwriteIfExists) {
        log.info("Adding variable on Modulepath: " + name + "=" + value);
        this.activateLibrariesTab();
        this.getLibraryTree().getItem(new String[]{MODULEPATH}).select();
        return this.addVariableShared(name, value, overwriteIfExists);
    }

    public BuildPathsPropertyPage removeVariable(String label, boolean removeGlobally) {
        log.info("Removing variable: " + label);
        this.selectLibrary((Matcher<TreeItem>)new TreeItemTextMatcher(label));
        new PushButton((ReferencedComposite)this, "Remove").click();
        return this.removeVariableShared(label, removeGlobally);
    }

    private BuildPathsPropertyPage removeVariableShared(String label, boolean removeGlobally) {
        if (removeGlobally) {
            new PushButton((ReferencedComposite)this, "Add Variable...").click();
            DefaultShell variableEntryShell = new DefaultShell("New Variable Classpath Entry");
            new DefaultTableItem((ReferencedComposite)variableEntryShell, label).select();
            new PushButton((ReferencedComposite)variableEntryShell, "Configure Variables...").click();
            WorkbenchPreferenceDialog workbenchDialog = new WorkbenchPreferenceDialog();
            workbenchDialog.open();
            new ClasspathVariablesPreferencePage((ReferencedComposite)workbenchDialog).removeVariable(label);
            WidgetIsFound applyAndCloseButton = new WidgetIsFound(Button.class, new Matcher[]{new WithMnemonicTextMatcher("Apply and Close")});
            Object button = applyAndCloseButton.test() ? new PushButton("Apply and Close") : new OkButton();
            button.click();
            DefaultShell varaiblesChanged = new DefaultShell("Classpath Variables Changed");
            new YesButton((ReferencedComposite)varaiblesChanged).click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)varaiblesChanged));
            new CancelButton((ReferencedComposite)variableEntryShell).click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)variableEntryShell));
            new WaitWhile((WaitCondition)new JobIsRunning());
        }
        new PushButton((ReferencedComposite)this, "Apply").click();
        new WaitWhile((WaitCondition)new JobIsRunning());
        return this;
    }

    public BuildPathsPropertyPage removeVariableFromClasspath(String label, boolean removeGlobally) {
        log.info("Removing variable from Classpath: " + label);
        this.getLibraryTree().getItem(new String[]{CLASSPATH}).getItem(label).select();
        new PushButton((ReferencedComposite)this, "Remove").click();
        this.getLibraryTree().getItem(new String[]{CLASSPATH}).select();
        return this.removeVariableShared(label, removeGlobally);
    }

    public BuildPathsPropertyPage removeVariableFromModulepath(String label, boolean removeGlobally) {
        log.info("Removing variable from Modulepath: " + label);
        this.getLibraryTree().getItem(new String[]{MODULEPATH}).getItem(label).select();
        new PushButton((ReferencedComposite)this, "Remove").click();
        this.getLibraryTree().getItem(new String[]{MODULEPATH}).select();
        return this.removeVariableShared(label, removeGlobally);
    }

    public BuildPathsPropertyPage selectLibrary(Matcher<TreeItem> matcher) {
        new DefaultTreeItem(this.getLibraryTree(), new Matcher[]{matcher}).select();
        return this;
    }

    public List<String> getLibraries() {
        LinkedList<String> libraries = new LinkedList<String>();
        for (org.eclipse.reddeer.swt.api.TreeItem ti : this.getLibraryTree().getItems()) {
            if (ti.getText().equals(CLASSPATH) || ti.getText().equals(MODULEPATH)) {
                for (org.eclipse.reddeer.swt.api.TreeItem tiPath : ti.getItems()) {
                    libraries.addLast(tiPath.getText());
                }
                continue;
            }
            libraries.addLast(ti.getText());
        }
        return libraries;
    }

    public List<String> getModulepathLibraries() {
        return this.getLibrariesPaths(MODULEPATH);
    }

    public List<String> getClasspathLibraries() {
        return this.getLibrariesPaths(CLASSPATH);
    }

    private List<String> getLibrariesPaths(String pathType) {
        LinkedList<String> libraries = new LinkedList<String>();
        for (org.eclipse.reddeer.swt.api.TreeItem ti : this.getLibraryTree().getItems()) {
            if (!ti.getText().equals(pathType)) continue;
            for (org.eclipse.reddeer.swt.api.TreeItem tiPath : ti.getItems()) {
                libraries.addLast(tiPath.getText());
            }
        }
        return libraries;
    }

    private Tree getLibraryTree() {
        this.activateLibrariesTab();
        return new DefaultTree((ReferencedComposite)this, 1, new Matcher[0]);
    }
}

