/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.matcher;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.reddeer.gef.finder.FigureFinder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;

public class IsEditPartWithLabel
extends BaseMatcher<EditPart> {
    private Matcher<String> matcher;

    public IsEditPartWithLabel(String label) {
        this((Matcher<String>)Is.is((Object)label));
    }

    public IsEditPartWithLabel(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(Object obj) {
        GraphicalEditPart gep;
        if (obj instanceof GraphicalEditPart && (gep = (GraphicalEditPart)obj).isSelectable()) {
            List<IFigure> labels = new FigureFinder().find(gep.getFigure(), (Matcher<?>)new IsInstanceOf(Label.class));
            for (IFigure figure : labels) {
                String label = ((Label)figure).getText();
                if (!this.matcher.matches((Object)label)) continue;
                return true;
            }
            List<IFigure> textFlows = new FigureFinder().find(gep.getFigure(), (Matcher<?>)new IsInstanceOf(TextFlow.class));
            for (IFigure figure : textFlows) {
                String text = ((TextFlow)figure).getText();
                if (!this.matcher.matches((Object)text)) continue;
                return true;
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("is EditPart with label '" + this.matcher.toString() + "'");
    }
}

