/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.logparser.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.reddeer.logparser.LogParserActivator;
import org.eclipse.reddeer.logparser.dialogs.ParseRuleDialog;
import org.eclipse.reddeer.logparser.model.ParseRule;
import org.eclipse.reddeer.logparser.preferences.LogParserPreferencesPageModel;
import org.eclipse.reddeer.logparser.preferences.ParseRuleLabelProvider;
import org.eclipse.reddeer.logparser.preferences.ParseRuleNameSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LogParserPreferecesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer parseRuleviewer;
    private Button btnAdd;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnDuplicate;
    private List<ParseRule> currentParseRules;
    private List<ParseRule> originalParseRules;

    public LogParserPreferecesPage() {
        this.noDefaultButton();
        this.setPreferenceStore(LogParserActivator.getDefault().getPreferenceStore());
        this.setDescription("Add, remove or edit RedDeer Log Parser rules");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout(2, false));
        pageComposite.setLayoutData((Object)new GridData(1808));
        this.parseRuleviewer = new TableViewer(pageComposite, 68356);
        this.parseRuleviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.parseRuleviewer.setLabelProvider((IBaseLabelProvider)new ParseRuleLabelProvider());
        this.parseRuleviewer.setSorter((ViewerSorter)new ParseRuleNameSorter());
        this.currentParseRules = LogParserPreferencesPageModel.getParseRules();
        this.originalParseRules = new ArrayList<ParseRule>(this.currentParseRules);
        this.parseRuleviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LogParserPreferecesPage.this.setButtonsSensitivity();
            }
        });
        Table table = this.parseRuleviewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData tableGridData = new GridData(1808);
        tableGridData.verticalSpan = 4;
        table.setLayoutData((Object)tableGridData);
        String[] headerNames = new String[]{"Rule Name", "Description", "Include Regex", "ExcludeRegex"};
        int[] columnAligments = new int[]{16384, 16384, 16384, 16384};
        int index = 0;
        while (index < headerNames.length) {
            TableColumn tc = new TableColumn(table, columnAligments[index]);
            tc.setText(headerNames[index]);
            ++index;
        }
        this.parseRuleviewer.setInput(this.currentParseRules);
        this.packParseRuleColumns();
        this.createButtons(pageComposite);
        this.setButtonsSensitivity();
        pageComposite.pack();
        return pageComposite;
    }

    private void createButtons(Composite parent) {
        GridData buttonGridData = new GridData(0x1000000, 1, false, false);
        buttonGridData.widthHint = 120;
        buttonGridData.verticalAlignment = 1;
        this.btnAdd = new Button(parent, 8);
        this.btnAdd.setLayoutData((Object)buttonGridData);
        this.btnAdd.setText("&Add...");
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPreferecesPage.this.addRule();
            }
        });
        this.btnEdit = new Button(parent, 8);
        this.btnEdit.setText("&Edit...");
        this.btnEdit.setLayoutData((Object)buttonGridData);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPreferecesPage.this.editRule();
            }
        });
        this.btnDuplicate = new Button(parent, 8);
        this.btnDuplicate.setText("Dupli&cate...");
        this.btnDuplicate.setLayoutData((Object)buttonGridData);
        this.btnDuplicate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPreferecesPage.this.duplicateRule();
            }
        });
        this.btnRemove = new Button(parent, 8);
        this.btnRemove.setText("&Remove");
        this.btnRemove.setLayoutData((Object)buttonGridData);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserPreferecesPage.this.removeRule();
            }
        });
    }

    private void setButtonsSensitivity() {
        this.btnAdd.setEnabled(true);
        boolean enable = true;
        if (this.parseRuleviewer.getSelection().isEmpty()) {
            enable = false;
        }
        this.btnEdit.setEnabled(enable);
        this.btnRemove.setEnabled(enable);
        this.btnDuplicate.setEnabled(enable);
    }

    public boolean performOk() {
        LogParserPreferencesPageModel.saveParseRules(this.currentParseRules);
        boolean result = super.performOk();
        LogParserActivator.notifyAllPropertyPageListeners(new PropertyChangeEvent((Object)this, "RULES", this.originalParseRules, this.currentParseRules));
        return result;
    }

    private void addRule() {
        ParseRuleDialog parseRuleDialog = new ParseRuleDialog(this.parseRuleviewer.getControl().getShell(), new ParseRule(), this.currentParseRules);
        if (parseRuleDialog.open() == 0) {
            ParseRule newParseRule = parseRuleDialog.getParseRule();
            this.parseRuleviewer.add((Object)newParseRule);
            this.currentParseRules.add(newParseRule);
        }
    }

    private void editRule() {
        ParseRule updParseRule = ((ParseRule)this.parseRuleviewer.getStructuredSelection().getFirstElement()).clone();
        ParseRule updModelParseRule = this.currentParseRules.get(this.currentParseRules.indexOf(updParseRule));
        ParseRuleDialog parseRuleDialog = new ParseRuleDialog(this.parseRuleviewer.getControl().getShell(), updParseRule, this.currentParseRules);
        if (parseRuleDialog.open() == 0) {
            ParseRule.copyFields(parseRuleDialog.getParseRule(), updModelParseRule);
            this.parseRuleviewer.setInput(this.currentParseRules);
            this.parseRuleviewer.setSelection((ISelection)new StructuredSelection((Object)updModelParseRule));
        }
    }

    private void removeRule() {
        ParseRule removeParseRule = ((ParseRule)this.parseRuleviewer.getStructuredSelection().getFirstElement()).clone();
        this.parseRuleviewer.remove((Object)removeParseRule);
        this.currentParseRules.remove(removeParseRule);
    }

    private void duplicateRule() {
        ParseRule duplicateParseRule = ((ParseRule)this.parseRuleviewer.getStructuredSelection().getFirstElement()).clone();
        duplicateParseRule.setName(this.getDuplicateUniqueName(duplicateParseRule.getName()));
        ParseRuleDialog parseRuleDialog = new ParseRuleDialog(this.parseRuleviewer.getControl().getShell(), duplicateParseRule, this.currentParseRules);
        if (parseRuleDialog.open() == 0) {
            ParseRule newParseRule = parseRuleDialog.getParseRule();
            this.parseRuleviewer.add((Object)newParseRule);
            this.currentParseRules.add(newParseRule);
        }
    }

    private String getDuplicateUniqueName(String origRuleName) {
        Pattern regex = Pattern.compile(" \\(\\d+\\)");
        Matcher m = regex.matcher(origRuleName);
        String nameIndex = null;
        while (m.find()) {
            nameIndex = m.group();
        }
        int newNameIndex = 0;
        String origRuleNameWithoutNumber = origRuleName;
        if (nameIndex == null) {
            newNameIndex = 1;
        } else {
            nameIndex = nameIndex.substring(2, nameIndex.length() - 1);
            newNameIndex = Integer.parseInt(nameIndex) + 1;
            origRuleNameWithoutNumber = origRuleName.substring(0, origRuleName.lastIndexOf(" ("));
        }
        boolean nameIsUnique = false;
        String newParseRuleName = "";
        List<ParseRule> parseRules = this.currentParseRules;
        while (!nameIsUnique) {
            newParseRuleName = String.valueOf(origRuleNameWithoutNumber) + " (" + newNameIndex + ")";
            boolean newParseRuleNameExists = false;
            Iterator<ParseRule> itParseRule = parseRules.iterator();
            while (!newParseRuleNameExists && itParseRule.hasNext()) {
                if (!itParseRule.next().getName().equalsIgnoreCase(newParseRuleName)) continue;
                newParseRuleNameExists = true;
            }
            if (newParseRuleNameExists) {
                ++newNameIndex;
                continue;
            }
            nameIsUnique = true;
        }
        return newParseRuleName;
    }

    private void packParseRuleColumns() {
        TableColumn[] tableColumnArray = this.parseRuleviewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            ++n2;
        }
    }
}

