/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.autobuilding;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.direct.preferences.PreferencesUtil;
import org.eclipse.reddeer.junit.requirement.AbstractRequirement;

public class AutoBuildingRequirement
extends AbstractRequirement<AutoBuilding> {
    private boolean originalValue;

    public void fulfill() {
        this.originalValue = PreferencesUtil.isAutoBuildingOn();
        if (((AutoBuilding)this.annotation).value()) {
            PreferencesUtil.setAutoBuildingOn();
        } else {
            PreferencesUtil.setAutoBuildingOff();
        }
    }

    public void cleanUp() {
        if (!((AutoBuilding)this.annotation).cleanup()) {
            return;
        }
        if (this.originalValue) {
            PreferencesUtil.setAutoBuildingOn();
        } else {
            PreferencesUtil.setAutoBuildingOff();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AutoBuilding {
        public boolean value() default true;

        public boolean cleanup() default true;
    }
}

