/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test;

import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.resolver.WidgetResolver;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class WidgetResolverTest {
    private Logger log = Logger.getLogger(WidgetResolverTest.class);

    @Test
    public void parentMatchesChildrenTest() {
        Shell shell = (Shell)new DefaultShell().getSWTWidget();
        List all = WidgetLookup.getInstance().activeWidgets((Control)shell, (Matcher)new BaseMatcher<Widget>(){

            public boolean matches(Object obj) {
                return true;
            }

            public void describeTo(Description desc) {
            }
        });
        this.log.info("Testing " + all.size() + " widgets for matching children to parent.");
        Assert.assertFalse((String)"Shell is empty, test cannot be done.", (boolean)all.isEmpty());
        for (Widget c : all) {
            List<Widget> children = this.getChildrenSync(c);
            Widget p = this.getParentSync(c);
            for (Widget w : children) {
                Widget parent = this.getParentSync(w);
                Assert.assertNotNull((String)("Widget " + this.syncToString(w) + " was returned as a child of control " + this.syncToString(c) + " but WidgetResolver.getInstance().getParent() returned null."), (Object)parent);
                if (c instanceof CTabItem) {
                    Assert.assertEquals((String)("For child " + this.syncToString(w) + " of CTabItem was return wrong parent."), (Object)p, (Object)parent);
                } else {
                    Assert.assertEquals((String)("For child " + this.syncToString(w) + " was returned wrong parent " + this.syncToString(parent)), (Object)c, (Object)parent);
                }
                this.log.info("Child widget " + this.syncToString(w) + " matches to its parent widget " + this.syncToString(c));
            }
        }
    }

    List<Widget> getChildrenSync(final Widget widget) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<Widget>>(){

            public List<Widget> run() {
                return WidgetResolver.getInstance().getChildren(widget);
            }
        });
    }

    Widget getParentSync(final Widget widget) {
        return (Widget)Display.syncExec((ResultRunnable)new ResultRunnable<Widget>(){

            public Widget run() {
                return WidgetResolver.getInstance().getParent(widget);
            }
        });
    }

    String syncToString(final Widget widget) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return widget.toString();
            }
        });
    }
}

