/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.text;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class StyledTextTest {
    private StyledText styledText;

    @BeforeClass
    public static void openView() {
        new WorkbenchView("RedDeer SWT Controls").open();
    }

    @After
    public void setup() {
        this.closeTestingShell();
    }

    @Test
    public void defaultStyledTextTest() {
        Assert.assertTrue((boolean)new DefaultStyledText().getText().equals("Styled text"));
        DefaultStyledText styledText = new DefaultStyledText("Styled text");
        Assert.assertTrue((boolean)styledText.getText().equals("Styled text"));
        styledText.setText("Modified styled text");
        Assert.assertTrue((boolean)styledText.getText().equals("Modified styled text"));
    }

    @Test
    public void defaultStyledTextGetPositionTest() {
        this.openTestingShell();
        DefaultStyledText sText = new DefaultStyledText();
        Assert.assertEquals((long)sText.getPositionOfText("styledText"), (long)8L);
    }

    @Test
    public void defaultStyledTextGetPositionNonExistingTest() {
        this.openTestingShell();
        DefaultStyledText sText = new DefaultStyledText();
        Assert.assertEquals((long)-1L, (long)sText.getPositionOfText("styledText1"));
    }

    private void openTestingShell() {
        org.eclipse.reddeer.common.util.Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Display display = Display.getDefault();
                Shell shell = new Shell(display);
                shell.setLayout((Layout)new GridLayout());
                shell.setText("Testing shell");
                StyledTextTest.this.styledText = new StyledText((Composite)shell, 0);
                StyledTextTest.this.styledText.setText("Testing styledText widget.");
                shell.open();
                shell.setFocus();
            }
        });
        new DefaultShell("Testing shell");
    }

    private void closeTestingShell() {
        org.eclipse.reddeer.common.util.Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell[] shellArray = org.eclipse.reddeer.common.util.Display.getDisplay().getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell.getText().equals("Testing shell")) {
                        shell.dispose();
                        break;
                    }
                    ++n2;
                }
            }
        });
        new WaitWhile((WaitCondition)new ShellIsAvailable("Testing shell"));
    }
}

