/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.autobuilding;

import org.eclipse.reddeer.direct.preferences.PreferencesUtil;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.RequirementsBuilder;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.test.autobuilding.AutoBuildingRequirementOffTest;
import org.eclipse.reddeer.requirements.test.autobuilding.AutoBuildingRequirementOnTest;
import org.eclipse.reddeer.requirements.test.autobuilding.AutoBuildingRequirementWithoutCleanupTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class AutoBuildingRequirementTest {
    private static boolean autoBuilding;

    @BeforeClass
    public static void getOriginalValueOfAutoBuilding() {
        autoBuilding = PreferencesUtil.isAutoBuildingOn();
    }

    @AfterClass
    public static void setAutoBuildingToOriginalValue() {
        if (autoBuilding) {
            PreferencesUtil.setAutoBuildingOn();
        } else {
            PreferencesUtil.setAutoBuildingOff();
        }
    }

    @Test
    public void autoBuildRequirementOnTest() {
        PreferencesUtil.setAutoBuildingOff();
        Requirements requirements = this.getRequirements(AutoBuildingRequirementOnTest.class);
        requirements.fulfill();
        Assert.assertTrue((boolean)PreferencesUtil.isAutoBuildingOn());
        requirements.cleanUp();
        Assert.assertFalse((boolean)PreferencesUtil.isAutoBuildingOn());
    }

    @Test
    public void autoBuildRequirementOffTest() {
        PreferencesUtil.setAutoBuildingOn();
        Requirements requirements = this.getRequirements(AutoBuildingRequirementOffTest.class);
        requirements.fulfill();
        Assert.assertFalse((boolean)PreferencesUtil.isAutoBuildingOn());
        requirements.cleanUp();
        Assert.assertTrue((boolean)PreferencesUtil.isAutoBuildingOn());
    }

    @Test
    public void autoBuildRequirementOffWithoutCleanupTest() {
        PreferencesUtil.setAutoBuildingOff();
        Requirements requirements = this.getRequirements(AutoBuildingRequirementWithoutCleanupTest.class);
        requirements.fulfill();
        Assert.assertTrue((boolean)PreferencesUtil.isAutoBuildingOn());
        requirements.cleanUp();
        Assert.assertTrue((boolean)PreferencesUtil.isAutoBuildingOn());
    }

    private Requirements getRequirements(Class<?> klass) {
        RequirementsBuilder reqBuilder = new RequirementsBuilder();
        RequirementConfigurationSet configSet = new RequirementConfigurationSet();
        return reqBuilder.build(configSet, klass);
    }
}

