/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.openperspective;

import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.RequirementsBuilder;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.exception.RequirementsLayerException;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.requirements.test.openperspective.NonExistingPerspective;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class OpenPerspectiveRequirementTest {
    private String oldCaptureScreenshotPropertyValue = null;
    private boolean propertyHasChanged = false;

    @Test
    public void fulfillJavaPerspectiveTest() {
        Requirements requirements = this.getRequirements(JavaPerspectiveTestClass.class);
        requirements.fulfill();
    }

    @Test(expected=RequirementsLayerException.class)
    public void fulfillNonExistingPerspectiveTest() {
        if (!"false".equalsIgnoreCase(RedDeerProperties.CAPTURE_SCREENSHOT.getValue())) {
            this.oldCaptureScreenshotPropertyValue = RedDeerProperties.CAPTURE_SCREENSHOT.getValue();
            System.setProperty(RedDeerProperties.CAPTURE_SCREENSHOT.getName(), "false");
            this.propertyHasChanged = true;
        }
        Requirements requirements = this.getRequirements(NonExistingPerspectiveTestClass.class);
        requirements.fulfill();
    }

    @After
    public void setOldValueOfCaptureScreenshotProperty() {
        if (this.propertyHasChanged) {
            if (this.oldCaptureScreenshotPropertyValue == null) {
                System.clearProperty(RedDeerProperties.CAPTURE_SCREENSHOT.getName());
            } else {
                System.setProperty(RedDeerProperties.CAPTURE_SCREENSHOT.getName(), this.oldCaptureScreenshotPropertyValue);
            }
            this.propertyHasChanged = false;
        }
    }

    private Requirements getRequirements(Class<?> klass) {
        RequirementsBuilder reqBuilder = new RequirementsBuilder();
        RequirementConfigurationSet config = new RequirementConfigurationSet();
        return reqBuilder.build(config, klass);
    }

    @OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
    public static class JavaPerspectiveTestClass {
        @Test
        public void voidTest() {
        }
    }

    @OpenPerspectiveRequirement.OpenPerspective(value=NonExistingPerspective.class)
    public static class NonExistingPerspectiveTestClass {
        @Test
        public void voidTest() {
        }
    }
}

