/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jst.servlet.ui;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectSecondPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectThirdPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaEEPerspective;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@OpenPerspectiveRequirement.OpenPerspective(value=JavaEEPerspective.class)
@RunWith(value=RedDeerSuite.class)
public class WebProjectTest {
    private PackageExplorerPart packageExplorer;
    private String projectName = "web project";

    @Before
    public void openPackageExplorer() {
        this.packageExplorer = new PackageExplorerPart();
        this.packageExplorer.open();
    }

    @After
    public void deleteProject() {
        DeleteUtils.forceProjectDeletion((DefaultProject)this.packageExplorer.getProject(this.projectName), (boolean)true);
    }

    @Test
    public void createWebProject() {
        WebProjectWizard ww = new WebProjectWizard();
        ww.open();
        WebProjectFirstPage fp = new WebProjectFirstPage((WizardDialog)ww);
        fp.setProjectName(this.projectName);
        ww.finish();
        Assert.assertTrue((boolean)this.packageExplorer.containsProject(this.projectName));
    }

    @Test
    public void createWebProject1() {
        WebProjectWizard ww = new WebProjectWizard();
        ww.open();
        WebProjectFirstPage fp = new WebProjectFirstPage((WizardDialog)ww);
        fp.setProjectName(this.projectName);
        Assert.assertEquals((Object)this.projectName, (Object)fp.getProjectName());
        ww.next();
        WebProjectSecondPage sp = new WebProjectSecondPage((ReferencedComposite)ww);
        sp.addSourceFoldersOnBuildPath("source");
        try {
            sp.removeSourceFoldersOnBuildPath("src");
        }
        catch (CoreLayerException coreLayerException) {
            sp.removeSourceFoldersOnBuildPath("src/main/java");
        }
        Assert.assertEquals((long)1L, (long)sp.getSourceFolders().size());
        Assert.assertEquals((Object)"source", sp.getSourceFolders().get(0));
        ww.next();
        WebProjectThirdPage tp = new WebProjectThirdPage((ReferencedComposite)ww);
        tp.setGenerateWebXmlDeploymentDescriptor(true);
        ww.finish();
        Assert.assertTrue((boolean)this.packageExplorer.containsProject(this.projectName));
        Assert.assertTrue((boolean)this.packageExplorer.getProject(this.projectName).containsResource(new String[]{"source"}));
        Assert.assertTrue((boolean)this.packageExplorer.getProject(this.projectName).containsResource(new String[]{"src", "main", "webapp", "WEB-INF", "web.xml"}));
    }
}

