/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.m2e.core.ui.wizard;

import java.io.File;
import java.util.List;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenImportWizard;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class MavenImportWizardTest {
    @Test
    public void testImportingMavenProject() {
        String projectName = "maven-test-project";
        MavenImportWizard.importProject((String)this.getPath(projectName));
        this.assertProject(projectName);
    }

    @Test
    public void testImportingWrongMavenProject() {
        String projectName = "maven-wrong-project";
        MavenImportWizard.importProject((String)this.getPath(projectName));
        this.assertProject(projectName);
    }

    private String getPath(String projectName) {
        File file = new File(Activator.getTestResourcesLocation(MavenImportWizardTest.class), projectName);
        return file.getAbsolutePath();
    }

    private void assertProject(String projectName) {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        List projects = pe.getProjects();
        for (DefaultProject project : projects) {
            if (!project.getName().equals(projectName)) continue;
            return;
        }
        Assert.fail((String)("Project '" + projectName + "' wasn't created properly"));
    }
}

