/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.views;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.core.resources.ProjectItem;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ResourceNavigatorTest {
    private static final String PROJECT_NAME = "ResourceNavigatorTestProject";
    private static final String SOURCE_FOLDER = "src";
    private static final String PACKAGE_NAME = "org.eclipse.reddeer.eclipse.jdt.navigator";
    private static final String CLASS_NAME = "Test";
    private ResourceNavigator navigator;

    @Before
    public void setUp() {
        this.navigator = new ResourceNavigator();
    }

    @Test
    public void open() {
        this.navigator.open();
        String activeViewTitle = WorkbenchPartLookup.getInstance().getActiveWorkbenchPartTitle();
        Assert.assertTrue((String)("Active view have to be Navigator or Navigator (Deprecated) but is " + activeViewTitle), (activeViewTitle.equals("Navigator") || activeViewTitle.equals("Navigator (Deprecated)") ? 1 : 0) != 0);
    }

    @Test
    public void navigation() {
        this.createProject(PROJECT_NAME);
        this.createClass(PROJECT_NAME, PACKAGE_NAME, CLASS_NAME);
        DefaultProject project = this.navigator.getProject(PROJECT_NAME);
        ProjectItem item = project.getProjectItem(new String[]{SOURCE_FOLDER});
        String[] stringArray = PACKAGE_NAME.split("[.]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            item = item.getProjectItem(new String[]{name});
            ++n2;
        }
        item = item.getProjectItem(new String[]{"Test.java"});
    }

    private void createClass(String projectName, String packageName, String className) {
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage page = new NewClassWizardPage((ReferencedComposite)classDialog);
        page.setName(className);
        page.setPackage(packageName);
        page.setSourceFolder(String.valueOf(projectName) + "/" + SOURCE_FOLDER);
        classDialog.finish();
    }

    private void createProject(String projectName) {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)dialog).setProjectName(projectName);
        dialog.finish();
    }

    @After
    public void tearDown() {
        if (this.navigator != null && this.navigator.containsProject(PROJECT_NAME)) {
            DeleteUtils.forceProjectDeletion((DefaultProject)this.navigator.getProject(PROJECT_NAME), (boolean)true);
        }
    }
}

