/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.ctab;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabFolder;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabItem;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CTabFolderTest
extends SWTLayerTestCase {
    private static final String ITEM_LABEL_PREFIX = "Item ";
    private static final String TOOLTIP_PREFIX = "Tool for Item ";
    private static final String CONTENT_PREFIX = "Content for Item ";

    @Override
    protected void createControls(Shell shell) {
        shell.setLayout((Layout)new FillLayout());
        CTabFolder folder = new CTabFolder((Composite)shell, 2048);
        int i = 0;
        while (i < 4) {
            CTabItem item = new CTabItem(folder, 64);
            item.setText(ITEM_LABEL_PREFIX + i);
            item.setToolTipText(TOOLTIP_PREFIX + i);
            Text text = new Text((Composite)folder, 2);
            text.setText(CONTENT_PREFIX + i);
            item.setControl((Control)text);
            ++i;
        }
    }

    @Test
    public void findByIndexAndActivate() {
        int index = 2;
        DefaultCTabItem tabItem = new DefaultCTabItem(index, new Matcher[0]);
        tabItem.activate();
        String expectedCTabItemContent = CONTENT_PREFIX + index;
        String cTabItemContent = new DefaultText(0, new Matcher[0]).getText();
        Assert.assertTrue((String)("cTabItem content is " + cTabItemContent + "\nbut expected CTabItem content is " + expectedCTabItemContent), (boolean)cTabItemContent.equals(expectedCTabItemContent));
        Assert.assertEquals((Object)tabItem, (Object)new DefaultCTabFolder().getSelection());
    }

    @Test
    public void findByNameAndActivate() {
        int index = 1;
        DefaultCTabItem tabItem = new DefaultCTabItem(ITEM_LABEL_PREFIX + index);
        tabItem.activate();
        String expectedCTabItemContent = CONTENT_PREFIX + index;
        String cTabItemContent = new DefaultText(0, new Matcher[0]).getText();
        Assert.assertTrue((String)("cTabItem content is " + cTabItemContent + "\nbut expected CTabItem content is " + expectedCTabItemContent), (boolean)cTabItemContent.equals(expectedCTabItemContent));
        Assert.assertEquals((Object)tabItem, (Object)new DefaultCTabFolder().getSelection());
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByIndex() {
        new DefaultCTabItem(5, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByLabel() {
        new DefaultCTabItem("NON_EXISTING_#$");
    }

    @Test
    public void close() {
        int index = 3;
        DefaultCTabItem cTabItem = new DefaultCTabItem(index, new Matcher[0]);
        cTabItem.close();
        try {
            new DefaultCTabItem(index, new Matcher[0]);
            Assert.fail((String)("CTabItem with index " + index + " was found but has to be closed"));
        }
        catch (CoreLayerException coreLayerException) {}
    }
}

