/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.wizards;

import java.util.ArrayList;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.workbench.condition.EditorWithTitleIsActive;
import org.eclipse.reddeer.workbench.handler.EditorHandler;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class NewClassCreationWizardTest {
    protected static final String PROJECT_NAME = "testproject";
    protected static final String CLASS_NAME = "ClassName";
    protected static final String SOURCE_FOLDER_NAME = "testproject/src";
    protected static final String PACKAGE_NAME = "org.example.test";
    protected static final String ENCLOSING_TYPE_CUSTOM_VALUE = "org.example.test.ClassName";

    @BeforeClass
    public static void setup() {
        NewClassCreationWizardTest.createTestProject();
    }

    @After
    public void closeAllEditors() {
        EditorHandler.getInstance().closeAll(true);
    }

    @AfterClass
    public static void clean() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        pe.deleteAllProjects(true, TimePeriod.LONG);
    }

    @Test
    public void testCreateNewClass() {
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage classPage = new NewClassWizardPage((ReferencedComposite)classDialog);
        classPage.setPackage(PACKAGE_NAME).setName(CLASS_NAME);
        classDialog.finish();
        new WaitUntil((WaitCondition)new EditorWithTitleIsActive("ClassName.java"), TimePeriod.LONG);
        TextEditor te = new TextEditor("ClassName.java");
        Assert.assertTrue((String)"Class source file should contain String 'package org.example.test'", (te.getPositionOfText("package org.example.test", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Class source file should contain String 'public class ClassName'", (te.getPositionOfText("public class ClassName", 0) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateNewClassWithCustomSettings() {
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage classPage = new NewClassWizardPage((ReferencedComposite)classDialog);
        classPage.setPackage("org.example.test2").setName("ClassName2");
        classPage.togglePackageModifier(true);
        classPage.toggleAbstractModifierCheckbox(true);
        classPage.setSuperclassName("java.lang.Exception");
        classPage.addExtendedInterface("javax.accessibility.AccessibleAction");
        classPage.setStaticMainMethod(true);
        classPage.toggleGenerateCommentsCheckbox(true);
        classDialog.finish();
        new WaitUntil((WaitCondition)new EditorWithTitleIsActive("ClassName2.java"), TimePeriod.LONG);
        TextEditor te = new TextEditor("ClassName2.java");
        Assert.assertTrue((String)"Class source file should contain String 'package org.example.test2'", (te.getPositionOfText("package org.example.test2", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Class source file should contain String '\nabstract class ClassName2 extends Exception implements AccessibleAction'", (te.getPositionOfText("\nabstract class ClassName2 extends Exception implements AccessibleAction", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Class source file should contain String 'import javax.accessibility.AccessibleAction;'", (te.getPositionOfText("import javax.accessibility.AccessibleAction;", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Class source file should contain String '/**\n *'", (te.getPositionOfText("/**\n *", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Class source file should contain String 'public static void main(String[] args)'", (te.getPositionOfText("public static void main(String[] args)", 0) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSettingAndGettingInputAndCheckboxValues() {
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage classPage = new NewClassWizardPage((ReferencedComposite)classDialog);
        classPage.setSourceFolder(SOURCE_FOLDER_NAME).setPackage(PACKAGE_NAME).setName(CLASS_NAME);
        Assert.assertTrue((String)"Source folder name obtained from the input using getSourceFolder() function is not the same as name set using setSourceFolder().", (boolean)classPage.getSourceFolder().equals(SOURCE_FOLDER_NAME));
        Assert.assertTrue((String)"Package name obtained from the input using getPackage() function is not the same as name set using setPackage().", (boolean)classPage.getPackage().equals(PACKAGE_NAME));
        Assert.assertTrue((String)"Class name obtained from the input using getName() function is not the same as name set using setName().", (boolean)classPage.getName().equals(CLASS_NAME));
        classPage.toggleEnclosingTypeCheckbox(true);
        String enclosingTypeDefaultValue = classPage.getEnclosingType();
        classPage.setEnclosingType(ENCLOSING_TYPE_CUSTOM_VALUE);
        Assert.assertTrue((String)"Class enclosing type obtained from the wizard using getEnclosingType() is not the same as the type given using setEnclosingType().", (boolean)classPage.getEnclosingType().equals(ENCLOSING_TYPE_CUSTOM_VALUE));
        classPage.setEnclosingType(enclosingTypeDefaultValue);
        Assert.assertTrue((String)("Currently set modifier should be 'public', but is '" + classPage.getCurrentModifier() + "'."), (boolean)classPage.togglePublicModifier(true).getCurrentModifier().equals("public"));
        Assert.assertTrue((String)("Currently set modifier should be 'package', but is '" + classPage.getCurrentModifier() + "'."), (boolean)classPage.togglePackageModifier(true).getCurrentModifier().equals("package"));
        Assert.assertTrue((String)("Currently set modifier should be 'private', but is '" + classPage.getCurrentModifier() + "'."), (boolean)classPage.togglePrivateModifier(true).getCurrentModifier().equals("private"));
        Assert.assertTrue((String)("Currently set modifier should be 'protected', but is '" + classPage.getCurrentModifier() + "'."), (boolean)classPage.toggleProtectedModifier(true).getCurrentModifier().equals("protected"));
        classPage.toggleEnclosingTypeCheckbox(false);
        Assert.assertTrue((String)"State of abstract modifier should be 'true', but is not.", (boolean)classPage.toggleAbstractModifierCheckbox(true).getAbstractModifierCheckboxState());
        Assert.assertTrue((String)"State of abstract modifier should be 'false', but is not.", (!classPage.toggleAbstractModifierCheckbox(false).getAbstractModifierCheckboxState() ? 1 : 0) != 0);
        classPage.getFinalModifierRadioButton().click();
        Assert.assertTrue((String)"State of final modifier should be 'true', but is not.", (boolean)classPage.getFinalModifierRadioButton().isSelected());
        classPage.getNoneModifierRadioButton().click();
        Assert.assertTrue((String)"State of none modifier should be 'true', but is not.", (boolean)classPage.getNoneModifierRadioButton().isSelected());
        Assert.assertFalse((String)"State of final modifier should be 'false', but is not.", (boolean)classPage.getFinalModifierRadioButton().isSelected());
        Assert.assertNotNull((Object)classPage.getAbstactModifierCheckBox());
        Assert.assertNotNull((Object)classPage.getNonSealedModifierRadioButton());
        Assert.assertNotNull((Object)classPage.getFinalModifierCheckBox());
        Assert.assertTrue((String)"State of checkbox for creating main method should be 'disabled', but is not.", (!classPage.setStaticMainMethod(false).getStaticMainMethodCheckboxState() ? 1 : 0) != 0);
        Assert.assertTrue((String)"State of checkbox for creating main method should be 'enabled', but is not.", (boolean)classPage.setStaticMainMethod(true).getStaticMainMethodCheckboxState());
        boolean generateCommentsCheckboxState = classPage.getGenerateCommentsCheckboxState();
        classPage.toggleGenerateCommentsCheckbox(!generateCommentsCheckboxState);
        Assert.assertTrue((String)("The Generate comments checkbox state should be '" + !generateCommentsCheckboxState + "' but is'" + generateCommentsCheckboxState + " '."), (boolean)(classPage.getGenerateCommentsCheckboxState() ^ generateCommentsCheckboxState));
        classPage.toggleGenerateCommentsCheckbox(generateCommentsCheckboxState);
        Assert.assertTrue((String)("The Generate comments checkbox state should be '" + generateCommentsCheckboxState + "' but is'" + !generateCommentsCheckboxState + " '."), (classPage.getGenerateCommentsCheckboxState() == generateCommentsCheckboxState ? 1 : 0) != 0);
        classDialog.cancel();
    }

    @Test
    public void testAddingAndRemovingExtendedInterfaces() {
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage classPage = new NewClassWizardPage((ReferencedComposite)classDialog);
        ArrayList<String> extendedIterfaceList = new ArrayList<String>();
        extendedIterfaceList.add("javax.accessibility.AccessibleAction");
        extendedIterfaceList.add("javax.accessibility.AccessibleEditableText");
        extendedIterfaceList.add("javax.accessibility.AccessibleExtendedTable");
        extendedIterfaceList.add("javax.accessibility.AccessibleStreamable");
        extendedIterfaceList.add("javax.accessibility.AccessibleText");
        for (String extendedInterfaceName : extendedIterfaceList) {
            classPage.addExtendedInterface(extendedInterfaceName);
        }
        Assert.assertTrue((String)"List of interfaces obtained using function getExtendedInterfaces() has to be the same as list interfaces, that has been set.", (boolean)classPage.getExtendedInterfaces().equals(extendedIterfaceList));
        for (String extendedInterfaceName : extendedIterfaceList) {
            classPage.removeExtendedInterface(extendedInterfaceName);
        }
        classDialog.cancel();
    }

    @Test
    public void testAddingAndRemovingNonexistingAndNotFullySpecifiedInterfaces() {
        NewClassCreationWizard classDialog = new NewClassCreationWizard();
        classDialog.open();
        NewClassWizardPage classPage = new NewClassWizardPage((ReferencedComposite)classDialog);
        try {
            classPage.addExtendedInterface("nonexisting.interface.name");
            Assert.fail((String)"RedDeer exception was not thrown when trying to add a non-existing extended interface.");
        }
        catch (RedDeerException redDeerException) {
            new PushButton("Cancel").click();
        }
        try {
            classPage.removeExtendedInterface("javax.accessibility.AccessibleAction");
            Assert.fail((String)"RedDeer exception was not thrown when trying to remove an extended interface, that is not on the list.");
        }
        catch (RedDeerException redDeerException) {}
        classPage.addExtendedInterface("org.w3c.dom.views.AbstractView");
        try {
            classPage.removeExtendedInterface("AbstractView");
            Assert.fail((String)"RedDeer exception was not thrown when trying to remove an extended interface, that was added, but was not fully specified.");
        }
        catch (RedDeerException redDeerException) {
            classPage.removeExtendedInterface("org.w3c.dom.views.AbstractView");
        }
        classDialog.cancel();
    }

    private static void createTestProject() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)dialog).setProjectName(PROJECT_NAME);
        dialog.finish();
    }
}

