/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.impl.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.reddeer.gef.GEFLayerException;
import org.eclipse.reddeer.gef.api.Palette;
import org.eclipse.reddeer.gef.handler.PaletteHandler;
import org.eclipse.reddeer.gef.matcher.IsToolEntry;
import org.eclipse.reddeer.gef.matcher.IsToolEntryWithLabel;
import org.eclipse.reddeer.gef.matcher.IsToolEntryWithParent;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public abstract class AbstractPalette
implements Palette {
    protected PaletteViewer paletteViewer;
    protected PaletteHandler paletteHandler;

    public AbstractPalette(PaletteViewer paletteViewer) {
        this.paletteViewer = paletteViewer;
        this.paletteHandler = PaletteHandler.getInstance();
    }

    @Override
    public void activateTool(String label) {
        this.activateTool(label, null);
    }

    @Override
    public void activateTool(String tool, String group) {
        ArrayList<BaseMatcher> matchers = new ArrayList<BaseMatcher>();
        matchers.add(new IsToolEntryWithLabel(tool));
        if (group != null) {
            matchers.add(new IsToolEntryWithParent(group));
        }
        AllOf matcher = new AllOf(matchers);
        this.activateTool((Matcher<PaletteEntry>)matcher, 0);
    }

    protected void activateTool(Matcher<PaletteEntry> matcher, int index) {
        List<PaletteEntry> entries = this.paletteHandler.getPaletteEntries(this.paletteViewer, matcher);
        if (entries.size() <= index) {
            throw new GEFLayerException("Cannot find tool entry with " + matcher + " at index " + index);
        }
        ToolEntry toolEntry = (ToolEntry)entries.get(index);
        this.paletteHandler.activateTool(this.paletteViewer, toolEntry);
    }

    @Override
    public String getActiveTool() {
        ToolEntry activeTool = this.paletteHandler.getActiveTool(this.paletteViewer);
        return this.paletteHandler.getLabel((PaletteEntry)activeTool);
    }

    @Override
    public List<String> getTools() {
        List<PaletteEntry> entries = this.paletteHandler.getPaletteEntries(this.paletteViewer, (Matcher<PaletteEntry>)new IsToolEntry());
        ArrayList<String> tools = new ArrayList<String>();
        for (PaletteEntry entry : entries) {
            tools.add(this.paletteHandler.getLabel(entry));
        }
        return tools;
    }
}

