/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.requirement.matcher;

import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.matcher.VersionMatcher;
import org.eclipse.reddeer.junit.requirement.RequirementException;
import org.eclipse.reddeer.junit.requirement.matcher.RequirementMatcher;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.ComplexConfiguration;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.ComplexRequirement;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.SimpleConfiguration;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.SimpleRequirement;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.SubConfiguration;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.SubRequirement;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RequirementMatcherTest {
    private static SimpleRequirement simpleReq;
    private static SimpleConfiguration simpleConfig;
    private static ComplexRequirement complexReq;
    private static ComplexConfiguration complexConfig;
    private static SubRequirement subReq;
    private static SubConfiguration subConfig;

    @BeforeClass
    public static void setup() {
        simpleReq = new SimpleRequirement();
        simpleConfig = new SimpleConfiguration();
        simpleConfig.setName("SimpleConfig");
        simpleConfig.setVersion("1.1");
        simpleReq.setConfiguration(simpleConfig);
        complexReq = new ComplexRequirement();
        complexConfig = new ComplexConfiguration();
        complexConfig.setComplexName("ComplexConfig");
        complexConfig.setComplexType("ComplexType");
        complexConfig.setComplexVersion("2.0");
        complexConfig.setSimpleConfiguration(simpleConfig);
        complexReq.setConfiguration(complexConfig);
        subReq = new SubRequirement();
        subConfig = new SubConfiguration();
        subConfig.setName("SimpleConfig");
        subConfig.setSubName("SubConfig");
        subReq.setConfiguration(subConfig);
    }

    @Test
    public void testNestedAttributeOnPreciseMatch() {
        RequirementMatcher matcher = new RequirementMatcher(ComplexRequirement.ComplexReq.class, "simpleConfiguration.name", "SimpleConfig");
        Assert.assertTrue((String)"Name attribute of configuration should be matched on precise match", (boolean)matcher.matches((Object)complexConfig));
    }

    @Test
    public void testNestedAttributeOnPreciseMatchInSubClass() {
        RequirementMatcher matcher = new RequirementMatcher(SubRequirement.SubReq.class, "name", "SimpleConfig");
        Assert.assertTrue((String)"Name attribute of configuration should be matched on precise match", (boolean)matcher.matches((Object)subConfig));
        matcher = new RequirementMatcher(SubRequirement.SubReq.class, "subName", "SubConfig");
        Assert.assertTrue((String)"Name attribute of configuration should be matched on precise match", (boolean)matcher.matches((Object)subConfig));
    }

    @Test
    public void testNestedAttributeOnVersionMatch() {
        RequirementMatcher matcher = new RequirementMatcher(ComplexRequirement.ComplexReq.class, "simpleConfiguration.version", (Matcher)new VersionMatcher(">1.0"));
        Assert.assertTrue((String)"Version attribute of configuration should be matched on version match", (boolean)matcher.matches((Object)complexConfig));
    }

    @Test(expected=RequirementException.class)
    public void testThrowExceptionOnNonexistingAttribute() {
        RequirementMatcher matcher = new RequirementMatcher(ComplexRequirement.ComplexReq.class, "noConfig.version", (Matcher)new VersionMatcher(">1.0"));
        matcher.matches((Object)complexConfig);
    }

    @Test(expected=RequirementException.class)
    public void testThrowExceptionOnNonexistingNestedAttribute() {
        RequirementMatcher matcher = new RequirementMatcher(ComplexRequirement.ComplexReq.class, "simpleConfiguration.what", (Matcher)new VersionMatcher(">1.0"));
        matcher.matches((Object)complexConfig);
    }

    @Test
    public void testRequirementRegexMatcherOnRegex() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "name", (Matcher)new RegexMatcher("Simple.*"));
        Assert.assertTrue((String)"Name attribute of configuration should be matched with regex.", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementRegexMatcherOnNonexistingValue() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "name", (Matcher)new RegexMatcher("Complex.*"));
        Assert.assertFalse((String)"Name of attribute should not be matched with current regex Complex*", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnPreciseMatch() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("1.1"));
        Assert.assertTrue((String)"Version attribute should be matched to version matcher with value 1.1", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnNonexistingvalue() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("2.0"));
        Assert.assertFalse((String)"Version attribute should not be matched to version matcher with value 2.0", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonGreaterThan() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher(">1.0"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value >1.0", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonGreaterThanNoMatch() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher(">1.1"));
        Assert.assertFalse((String)"Version attribute should match to version matcher with value >1.1", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonGreaterThanOrEquals() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher(">=1.1"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value >=1.1", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonGreaterThanOrEqualsNoMatch() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("<=1.1.1"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value >=1.1.1", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonRange() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("[1.1.0;1.2]"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value [1.1.0;1.2]", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonRange2() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("(1.0.4;1.2]"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value (1.0.4;1.2]", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonRangeNoMatch() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("(1.1;1.2]"));
        Assert.assertFalse((String)"Version attribute should not match to version matcher with value (1.1;1.2]", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonRange3() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("[0.9.0;1.1]"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value [0.9.0;1.1]", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonRangeNoMatch2() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("[0.9.0;1.1)"));
        Assert.assertFalse((String)"Version attribute should match to version matcher with value [0.9.0;1.1)", (boolean)matcher.matches((Object)simpleConfig));
    }

    @Test
    public void testRequirementVersionMatcherOnComparisonRange4() {
        RequirementMatcher matcher = new RequirementMatcher(SimpleRequirement.SimpleReq.class, "version", (Matcher)new VersionMatcher("[0.9.0;1.1.1)"));
        Assert.assertTrue((String)"Version attribute should match to version matcher with value [0.9.0;1.1.1)", (boolean)matcher.matches((Object)simpleConfig));
    }
}

