/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.cleanerrorlog;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.reddeer.eclipse.ui.views.log.LogView;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.RequirementsBuilder;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanerrorlog.CleanErrorLogRequirement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=RedDeerSuite.class)
public class CleanErrorLogRequirementTest {
    @Test
    public void testTestClassWithCleaningErrorLog() {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.requirements.test"));
        log.log((IStatus)new Status(4, "ERROR_1234", "Error 1234", (Throwable)new NullPointerException("NPE_1234")));
        this.getRequirements(TestClassWithCleaningErrorLog.class).fulfill();
        new LogView().open();
        Assert.assertTrue((boolean)new LogView().getErrorMessages().isEmpty());
    }

    @Test
    public void testTestClassWithoutCleaningErrorLog() {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.requirements.test"));
        log.log((IStatus)new Status(4, "ERROR_1234", "Error 1234", (Throwable)new NullPointerException("NPE_1234")));
        this.getRequirements(TestClassWithoutCleaningErrorLog.class).fulfill();
        new LogView().open();
        Assert.assertFalse((boolean)new LogView().getErrorMessages().isEmpty());
    }

    private Requirements getRequirements(Class<?> klass) {
        RequirementsBuilder reqBuilder = new RequirementsBuilder();
        RequirementConfigurationSet configSet = new RequirementConfigurationSet();
        return reqBuilder.build(configSet, klass);
    }

    @CleanErrorLogRequirement.CleanErrorLog
    @RunWith(value=RedDeerSuite.class)
    static class TestClassWithCleaningErrorLog {
        @Test
        public void test() {
        }
    }

    @RunWith(value=RedDeerSuite.class)
    static class TestClassWithoutCleaningErrorLog {
        @Test
        public void test() {
        }
    }
}

