/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.jre;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.debug.ui.jres.JREsPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.requirement.AbstractConfigurableRequirement;
import org.eclipse.reddeer.requirements.jre.JREConfiguration;
import org.eclipse.reddeer.requirements.property.RequirementPropertyExpandor;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;

public class JRERequirement
extends AbstractConfigurableRequirement<JREConfiguration, JRE> {
    private Logger log = Logger.getLogger(JRERequirement.class);

    public void fulfill() {
        this.log.info("JRE Requirement fulfill performed");
        this.log.debug("Configuration (name,version,path): %s, %s, %s", new Object[]{((JREConfiguration)this.configuration).getName(), ((JREConfiguration)this.configuration).getVersion(), ((JREConfiguration)this.configuration).getPath()});
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        JREsPreferencePage page = new JREsPreferencePage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)page);
        page.addJRE(this.getPath(), ((JREConfiguration)this.configuration).getName());
        if (((JRE)this.annotation).setDefault()) {
            page.setDefaultJRE(((JREConfiguration)this.configuration).getName());
        }
        dialog.ok();
    }

    public void cleanUp() {
        if (((JRE)this.annotation).cleanup()) {
            WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
            dialog.open();
            JREsPreferencePage page = new JREsPreferencePage((ReferencedComposite)dialog);
            dialog.select((PreferencePage)page);
            page.deleteJRE(((JREConfiguration)this.configuration).getName());
            dialog.ok();
        }
    }

    public Class<JREConfiguration> getConfigurationClass() {
        return JREConfiguration.class;
    }

    public String getPath() {
        return RequirementPropertyExpandor.getProperty(((JREConfiguration)this.configuration).getPath());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface JRE {
        public boolean cleanup() default false;

        public boolean setDefault() default false;
    }
}

