/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.wizards;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@CleanWorkspaceRequirement.CleanWorkspace
@RunWith(value=RedDeerSuite.class)
public class JavaProjectWizardTest {
    public static final String JAVA_PROJECT = "SimpleJavaProject";
    public static final String JAVA_MODULE_NAME = "simplejavaproject";
    public static final String JAVA_MODULE_INFO = "module-info.java";
    public static String DEFAULT_JAVA;

    @BeforeClass
    public static void findOutJavaVersionUsed() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        new RadioButton((ReferencedComposite)dialog, "Use an execution environment JRE:").toggle(true);
        DEFAULT_JAVA = new DefaultCombo((ReferencedComposite)dialog, 0, new Matcher[0]).getSelection();
        dialog.cancel();
    }

    @After
    public void cleanUp() {
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        explorer.deleteAllProjects(true);
    }

    @AfterClass
    public static void cleanUpClass() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne pageOne = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        pageOne.useExecutionEnvironmentJRE(DEFAULT_JAVA);
        dialog.cancel();
    }

    @Test
    public void testJavaProjectWizard() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne pageOne = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        pageOne.setProjectName(JAVA_PROJECT);
        pageOne.useDefaultLocation(true);
        dialog.next();
        NewJavaProjectWizardPageTwo pageTwo = new NewJavaProjectWizardPageTwo((ReferencedComposite)dialog);
        pageTwo.allowOutputFoldersForSourceFolders(true);
        dialog.finish();
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        Assert.assertTrue((boolean)explorer.containsProject(JAVA_PROJECT));
    }

    @Test
    public void testJavaProjectWizardCreateInfoModule() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne pageOne = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        pageOne.setProjectName(JAVA_PROJECT);
        pageOne.useExecutionEnvironmentJRE("JavaSE-11");
        new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.MEDIUM, false);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.MEDIUM, false);
        pageOne.createModuleInfoFile(true);
        pageOne.setModuleInfoFileName(JAVA_MODULE_NAME);
        dialog.finish(true, JAVA_MODULE_NAME);
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        Assert.assertTrue((boolean)explorer.containsProject(JAVA_PROJECT));
        Assert.assertTrue((boolean)explorer.getProject(JAVA_PROJECT).containsResource(new String[]{"src", JAVA_MODULE_INFO, JAVA_MODULE_NAME}));
    }

    @Test
    public void testJavaProjectWizardCreateInfoModuleDefaultName() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne pageOne = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        pageOne.setProjectName(JAVA_PROJECT);
        pageOne.useExecutionEnvironmentJRE("JavaSE-11");
        pageOne.createModuleInfoFile(true);
        dialog.finish();
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        Assert.assertTrue((boolean)explorer.containsProject(JAVA_PROJECT));
        Assert.assertTrue((boolean)explorer.getProject(JAVA_PROJECT).containsResource(new String[]{"src", JAVA_MODULE_INFO, JAVA_PROJECT}));
    }

    @Test
    public void testJavaProjectWizardDisabledModuleInfoCheckbox() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne pageOne = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        pageOne.setProjectName(JAVA_PROJECT);
        pageOne.useExecutionEnvironmentJRE("JavaSE-1.8");
        try {
            pageOne.createModuleInfoFile(true);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {}
        dialog.finish();
    }
}

