/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.condition;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.logging.Logger;

public class JobIsKilled
extends AbstractWaitCondition {
    private static final Logger log = Logger.getLogger(JobIsKilled.class);
    private Job[] currentJobs;
    private Set<String> jobsToBeKilled = new HashSet<String>();
    private Set<String> killedJobs = new HashSet<String>();

    public JobIsKilled(String ... jobsToBeKilled) {
        String[] stringArray = jobsToBeKilled;
        int n = jobsToBeKilled.length;
        int n2 = 0;
        while (n2 < n) {
            String jobToBeKilled = stringArray[n2];
            this.jobsToBeKilled.add(jobToBeKilled);
            ++n2;
        }
    }

    public boolean test() {
        Job job;
        Job[] jobArray = this.currentJobs = Job.getJobManager().find(null);
        int n = this.currentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            if (this.jobsToBeKilled.contains(job.getName())) {
                log.info("Job '" + job.getName() + "' will be killed");
                job.cancel();
                this.killedJobs.add(job.getName());
            }
            ++n2;
        }
        jobArray = this.currentJobs = Job.getJobManager().find(null);
        n = this.currentJobs.length;
        n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            if (this.killedJobs.contains(job.getName())) {
                log.info("The job '" + job.getName() + "' is still alive");
                return false;
            }
            ++n2;
        }
        return this.killedJobs.equals(this.jobsToBeKilled);
    }

    public String description() {
        return "at least one job is waiting for killing";
    }

    public String errorMessageWhile() {
        return "The following jobs were not killed " + this.jobsToBeKilled;
    }

    public String errorMessageUntil() {
        return "The following jobs has not been found: " + this.jobsToBeKilled;
    }
}

