/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test.installation.common.preferences;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;

public class AvailableSoftwareSitesPreferencePage
extends PreferencePage {
    public AvailableSoftwareSitesPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Install/Update", "Available Software Sites"});
    }

    public List<TableItem> getItems() {
        return new DefaultTable().getItems();
    }

    public TableItem getItem(String name) {
        for (TableItem item : this.getItems()) {
            if (!item.getText(0).equals(name)) continue;
            return item;
        }
        return null;
    }

    public TableItem getItem(String url, boolean alternateSearch) {
        if (!alternateSearch) {
            return this.getItem(url);
        }
        for (TableItem item : this.getItems()) {
            if (!item.getText(1).equals(url)) continue;
            return item;
        }
        return null;
    }

    public void toggleAllItems(boolean toggle) {
        for (TableItem item : this.getItems()) {
            item.setChecked(toggle);
        }
    }

    public void toggleItem(String name, boolean toggle) {
        this.getItem(name).setChecked(toggle);
    }

    public void toggleItem(String url, boolean toggle, boolean alternateSearch) {
        this.getItem(url, alternateSearch).setChecked(toggle);
    }

    public void selectItem(String name) {
        this.getItem(name).click();
    }

    public void selectItem(String url, boolean alternateSearch) {
        this.getItem(url, alternateSearch).click();
    }

    public boolean isItemEnabled(String name) {
        return this.getItem(name).getText(2).equals("Enabled");
    }

    public boolean isItemEnabled(String url, boolean alternateSearch) {
        return this.getItem(url, alternateSearch).getText(2).equals("Enabled");
    }

    public boolean isButtonEnabled(String buttonName) {
        return new PushButton(buttonName).isEnabled();
    }

    public void clickAdd() {
        new PushButton("Add...").click();
    }

    public void clickEdit() {
        new PushButton("Edit").click();
    }

    public void clickRemove() {
        new PushButton("Remove").click();
    }

    public void clickReload() {
        new PushButton("Reload").click();
    }

    public void clickEnable() {
        new PushButton("Enable").click();
    }

    public void clickDisable() {
        new PushButton("Disable").click();
    }

    public void clickImport() {
        new PushButton("Import...").click();
    }

    public void clickExport() {
        new PushButton("Export...").click();
    }
}

