/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.lookup;

import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.hamcrest.Matcher;

public class ViewLookup {
    private static ViewLookup instance;

    public static ViewLookup getInstance() {
        if (instance == null) {
            instance = new ViewLookup();
        }
        return instance;
    }

    public String[] findRegisteredViewPath(Matcher<String> title) {
        IViewDescriptor viewDescriptor = this.findView(title);
        IViewCategory categoryDescriptor = this.findViewCategory(viewDescriptor);
        return this.pathForView(viewDescriptor, categoryDescriptor);
    }

    private IViewDescriptor findView(Matcher<String> title) {
        IViewDescriptor[] views;
        IViewDescriptor[] iViewDescriptorArray = views = PlatformUI.getWorkbench().getViewRegistry().getViews();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor view = iViewDescriptorArray[n2];
            if (title.matches((Object)view.getLabel())) {
                return view;
            }
            ++n2;
        }
        throw new WorkbenchLayerException("View '" + title + "' is not registered in workbench");
    }

    private IViewCategory findViewCategory(IViewDescriptor viewDescriptor) {
        IViewCategory[] categories;
        IViewCategory[] iViewCategoryArray = categories = PlatformUI.getWorkbench().getViewRegistry().getCategories();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IViewCategory category = iViewCategoryArray[n2];
            IViewDescriptor[] iViewDescriptorArray = category.getViews();
            int n3 = iViewDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewDescriptor ivd = iViewDescriptorArray[n4];
                if (ivd.getId().equals(viewDescriptor.getId())) {
                    return category;
                }
                ++n4;
            }
            ++n2;
        }
        throw new WorkbenchLayerException("View '" + viewDescriptor.getLabel() + "' is not registered in any category");
    }

    private String[] pathForView(IViewDescriptor viewDescriptor, IViewCategory categoryDescriptor) {
        String[] path = new String[]{categoryDescriptor.getLabel(), viewDescriptor.getLabel()};
        return path;
    }
}

