/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.lookup;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.hamcrest.Matcher;

public class ToolItemLookup {
    private static final Logger logger = Logger.getLogger(ToolItemLookup.class);
    private static ToolItemLookup instance;

    private ToolItemLookup() {
    }

    public static ToolItemLookup getInstance() {
        if (instance == null) {
            instance = new ToolItemLookup();
        }
        return instance;
    }

    public ToolItem getToolItem(ReferencedComposite rc, int index, Matcher<?> ... matchers) {
        if (rc == null) {
            rc = this.findReferencedComposite();
        }
        return WidgetLookup.getInstance().activeWidget(rc, ToolItem.class, index, matchers);
    }

    public ReferencedComposite findReferencedComposite() {
        Control control = null;
        Control activeWidgetParentControl = WidgetLookup.getInstance().getActiveWidgetParentControl();
        control = activeWidgetParentControl instanceof Shell ? activeWidgetParentControl : this.getWorkbenchControl(activeWidgetParentControl);
        return new GenericReferencedComposite(control);
    }

    private Control getWorkbenchControl(final Control activeWorkbenchPartReference) {
        Control control = (Control)Display.syncExec((ResultRunnable)new ResultRunnable<Control>(){

            public Control run() {
                Control control = activeWorkbenchPartReference;
                while (!(control instanceof CTabFolder) && !(control instanceof Shell)) {
                    control = control.getParent();
                }
                return control;
            }
        });
        return control;
    }

    protected class GenericReferencedComposite
    implements ReferencedComposite {
        private Control control;

        public GenericReferencedComposite(Control control) {
            this.control = control;
        }

        @Override
        public Control getControl() {
            return this.control;
        }
    }
}

