/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.datatools.ui;

import java.io.File;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.matcher.TreeItemRegexMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.dialogs.DriverDialog;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.dse.views.DataSourceExplorerView;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.preferences.DriverPreferences;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.wizards.NewCPWizard;
import org.eclipse.reddeer.eclipse.datatools.sqltools.result.ui.ResultView;
import org.eclipse.reddeer.eclipse.datatools.sqltools.result.ui.SQLResult;
import org.eclipse.reddeer.eclipse.datatools.sqltools.result.ui.SQLResultStatus;
import org.eclipse.reddeer.eclipse.datatools.ui.DatabaseProfile;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverDefinition;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverTemplate;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsKilled;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ResultViewTest {
    private static String fileName = "h2-1.4.199.jar";
    private static String profile = "myDBProfile";

    @BeforeClass
    public static void genericConnectionProfileTest() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        DriverPreferences preferencePage = new DriverPreferences((ReferencedComposite)preferenceDialog);
        preferenceDialog.select((PreferencePage)preferencePage);
        List items = new DefaultTable().getItems();
        int i = 0;
        while (i < items.size()) {
            new DefaultTableItem(0, new Matcher[0]).select();
            new PushButton("Remove").click();
            DefaultShell removalShell = new DefaultShell("Confirm Driver Removal");
            new YesButton().click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)removalShell));
            ++i;
        }
        preferenceDialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning());
        DataSourceExplorerView dse = new DataSourceExplorerView();
        dse.open();
        DefaultTreeItem item = new DefaultTreeItem(new String[]{"Database Connections"});
        item.expand(TimePeriod.DEFAULT);
        List cpitems = item.getItems();
        for (TreeItem i2 : cpitems) {
            i2.select();
            new ContextMenuItem(new String[]{"Delete"}).select();
            DefaultShell deleteShell = new DefaultShell("Delete confirmation");
            new YesButton().click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)deleteShell));
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        DataSourceExplorerView dataSourceExplorer = new DataSourceExplorerView();
        dataSourceExplorer.open();
        List dbSources = dataSourceExplorer.getDatabaseConnections();
        if (!dbSources.contains(profile)) {
            ResultViewTest.createDatabaseProfile(profile);
        }
    }

    @After
    public void cleanup() {
        new WaitUntil((WaitCondition)new JobIsKilled(new String[]{"SQL Statement Execution"}), TimePeriod.DEFAULT, false);
    }

    private static void performSQLStatement(String profile, String statement) {
        DataSourceExplorerView dse = new DataSourceExplorerView();
        dse.open();
        DefaultTreeItem connectionItem = new DefaultTreeItem(new Matcher[]{new TreeItemRegexMatcher("Database Connections"), new TreeItemRegexMatcher(String.valueOf(profile) + ".*")});
        connectionItem.doubleClick();
        connectionItem.expand();
        new ContextMenuItem(new String[]{"Open SQL Scrapbook"}).select();
        DefaultEditor scrapbook = new DefaultEditor("SQL Scrapbook 0");
        List items = new LabeledCombo("Type:").getItems();
        String generic1x = "Generic JDBC_1.x";
        String generic10 = "Generic JDBC_1.0";
        if (items.contains(generic1x)) {
            new LabeledCombo("Type:").setSelection(generic1x);
        } else {
            new LabeledCombo("Type:").setSelection(generic10);
        }
        new DefaultCombo(1, new Matcher[0]).setSelection(profile);
        DefaultStyledText text = new DefaultStyledText();
        text.setText(statement);
        new WaitWhile((WaitCondition)new JobIsRunning());
        new ContextMenuItem(new String[]{"Execute All"}).select();
        new WaitUntil((WaitCondition)new ShellIsAvailable("SQL Statement Execution"), TimePeriod.DEFAULT, false);
        new WaitWhile((WaitCondition)new ShellIsAvailable("SQL Statement Execution"), TimePeriod.VERY_LONG);
        scrapbook.close(false);
    }

    private static void createDatabaseProfile(String profile) {
        File drvFile = new File("target" + File.separator + fileName);
        DriverTemplate dt = new DriverTemplate("Generic JDBC Driver", "1.0");
        DriverDefinition dd = new DriverDefinition();
        dd.setDriverClass("org.h2.Driver");
        dd.setDriverLibrary(drvFile.getAbsolutePath());
        dd.setDriverName("Test H2 Driver");
        dd.setDriverTemplate(dt);
        WorkbenchPreferenceDialog d = new WorkbenchPreferenceDialog();
        d.open();
        d.select(new String[]{"Data Management", "Connectivity", "Driver Definitions"});
        DriverPreferences preferencePage = new DriverPreferences((ReferencedComposite)d);
        DriverDialog wizard = preferencePage.addDriverDefinition();
        wizard.selectDriverTemplate("Generic JDBC Driver", "1.0");
        wizard.setName("Test H2 Driver");
        wizard.addDriverLibrary(drvFile.getAbsolutePath());
        wizard.setDriverClass("org.h2.Driver");
        wizard.ok();
        d.ok();
        DatabaseProfile dbProfile = new DatabaseProfile();
        dbProfile.setDatabase("sakila");
        dbProfile.setDatabase(profile);
        dbProfile.setDriverDefinition(dd);
        dbProfile.setHostname("jdbc:h2:~/test");
        dbProfile.setName("myDBProfile");
        dbProfile.setPassword("");
        dbProfile.setPort("8082");
        dbProfile.setUsername("sa");
        dbProfile.setVendor("Generic JDBC");
        NewCPWizard w = new NewCPWizard();
        w.open();
        w.createDatabaseProfile(dbProfile);
    }

    @Test
    public void testSQLResultViewFail() {
        this.testSQLResultView(true);
    }

    @Test
    public void testSQLResultViewSuccess() {
        this.testSQLResultView(false);
    }

    public void testSQLResultView(boolean fail) {
        this.dropTable();
        this.removeResults();
        if (fail) {
            ResultViewTest.performSQLStatement(profile, "CREATE TABLE test(INT ID,VARCHAR(40) NAME);");
        } else {
            ResultViewTest.performSQLStatement(profile, "CREATE TABLE test(ID INT,NAME VARCHAR(40));");
        }
        ResultView view = new ResultView();
        view.open();
        List result = view.getResults();
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        if (fail) {
            Assert.assertTrue((((SQLResult)result.get(0)).getStatus() == SQLResultStatus.FAILED || ((SQLResult)result.get(0)).getStatus() == SQLResultStatus.STARTED ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((((SQLResult)result.get(0)).getStatus() == SQLResultStatus.SUCCEEDED || ((SQLResult)result.get(0)).getStatus() == SQLResultStatus.STARTED ? 1 : 0) != 0);
        }
        this.dropTable();
        this.removeResults();
    }

    private void dropTable() {
        ResultViewTest.performSQLStatement(profile, "DROP TABLE TEST IF EXISTS;");
    }

    private void removeResults() {
        ResultView view = new ResultView();
        view.open();
        view.removeAllResults();
        List result = view.getResults();
        Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
    }
}

