/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.debug.ui.preferences;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.debug.ui.preferences.ConsolePreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ConsolePreferencePageTest {
    private ConsolePreferencePage consolePreferencePage;

    @Before
    public void openConsolePreferencePage() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        this.consolePreferencePage = new ConsolePreferencePage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)this.consolePreferencePage);
        this.consolePreferencePage.restoreDefaults();
        this.consolePreferencePage.apply();
    }

    @After
    public void closeConsolePreferencePage() {
        new WorkbenchPreferenceDialog().cancel();
    }

    @Test
    public void testLimitConsoleOutput() {
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOutputLimited());
        this.consolePreferencePage.toggleConsoleOutputLimited(false);
        Assert.assertFalse((boolean)this.consolePreferencePage.isConsoleOutputLimited());
        this.consolePreferencePage.toggleConsoleOutputLimited(true);
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOutputLimited());
    }

    @Test
    public void testSettingConsoleOutputSizeWithLimit() {
        this.consolePreferencePage.toggleConsoleOutputLimited(true);
        this.consolePreferencePage.setConsoleOutputSize(12345);
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOutputLimited());
        Assert.assertEquals((long)12345L, (long)this.consolePreferencePage.getConsoleOutputSize());
    }

    @Test
    public void testSettingConsoleOutputSizeWithoutLimit() {
        this.consolePreferencePage.toggleConsoleOutputLimited(false);
        this.consolePreferencePage.setConsoleOutputSize(54321);
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOutputLimited());
        Assert.assertEquals((long)54321L, (long)this.consolePreferencePage.getConsoleOutputSize());
    }

    @Test
    public void testShowConsoleOnOutput() {
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOpenedOnOutput());
        this.consolePreferencePage.toggleShowConsoleOnOutput(false);
        Assert.assertFalse((boolean)this.consolePreferencePage.isConsoleOpenedOnOutput());
        this.consolePreferencePage.toggleShowConsoleOnOutput(true);
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOpenedOnOutput());
    }

    @Test
    public void testShowConsoleOnError() {
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOpenedOnError());
        this.consolePreferencePage.toggleShowConsoleErrorWrite(false);
        Assert.assertFalse((boolean)this.consolePreferencePage.isConsoleOpenedOnError());
        this.consolePreferencePage.toggleShowConsoleErrorWrite(true);
        Assert.assertTrue((boolean)this.consolePreferencePage.isConsoleOpenedOnError());
    }
}

