/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jst.j2ee.ui.project.facet;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jst.j2ee.ui.project.facet.EarProjectFirstPage;
import org.eclipse.reddeer.eclipse.jst.j2ee.ui.project.facet.EarProjectInstallPage;
import org.eclipse.reddeer.eclipse.jst.j2ee.ui.project.facet.EarProjectWizard;
import org.eclipse.reddeer.eclipse.jst.j2ee.wizard.DefaultJ2EEComponentCreationWizard;
import org.eclipse.reddeer.eclipse.jst.j2ee.wizard.NewJ2EEComponentSelectionPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaEEPerspective;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@OpenPerspectiveRequirement.OpenPerspective(value=JavaEEPerspective.class)
@RunWith(value=RedDeerSuite.class)
public class EARProjectWizardTest {
    private String projectName = "EARProject";

    @After
    public void deleteProject() {
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        explorer.deleteAllProjects();
    }

    @Test
    public void createProject() {
        EarProjectWizard ear = new EarProjectWizard();
        ear.open();
        EarProjectFirstPage fp = new EarProjectFirstPage((WizardDialog)ear);
        fp.setProjectName(this.projectName);
        fp.setEARVersion("7.0");
        ear.next();
        EarProjectInstallPage ip = new EarProjectInstallPage((ReferencedComposite)ear);
        Assert.assertFalse((boolean)ip.isGenerateApplicationXML());
        ear.finish();
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        Assert.assertTrue((boolean)pe.containsProject(this.projectName));
    }

    @Test
    public void createProjectWithDefaultModules() {
        EarProjectWizard ear = new EarProjectWizard();
        ear.open();
        EarProjectFirstPage fp = new EarProjectFirstPage((WizardDialog)ear);
        fp.setProjectName(this.projectName);
        fp.setEARVersion("7.0");
        ear.next();
        EarProjectInstallPage ip = new EarProjectInstallPage((ReferencedComposite)ear);
        Assert.assertFalse((boolean)ip.isGenerateApplicationXML());
        DefaultJ2EEComponentCreationWizard componentWizard = ip.newModule();
        NewJ2EEComponentSelectionPage jee = new NewJ2EEComponentSelectionPage((ReferencedComposite)componentWizard);
        String ejb = jee.getEJBModuleName();
        String conn = jee.getConnectorModuleName();
        String web = jee.getWebModuleName();
        String appClient = jee.getApplicationClientModuleName();
        componentWizard.finish();
        ear.finish();
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        Assert.assertTrue((boolean)explorer.containsProject(this.projectName));
        Assert.assertTrue((boolean)explorer.containsProject(ejb));
        Assert.assertTrue((boolean)explorer.containsProject(conn));
        Assert.assertTrue((boolean)explorer.containsProject(web));
        Assert.assertTrue((boolean)explorer.containsProject(appClient));
    }

    @Test
    public void createProjectWithWebModule() {
        EarProjectWizard ear = new EarProjectWizard();
        ear.open();
        EarProjectFirstPage fp = new EarProjectFirstPage((WizardDialog)ear);
        fp.setProjectName(this.projectName);
        fp.setEARVersion("10.0");
        ear.next();
        EarProjectInstallPage ip = new EarProjectInstallPage((ReferencedComposite)ear);
        Assert.assertFalse((boolean)ip.isGenerateApplicationXML());
        DefaultJ2EEComponentCreationWizard jeeWizard = ip.newModule();
        NewJ2EEComponentSelectionPage jee = new NewJ2EEComponentSelectionPage((ReferencedComposite)jeeWizard);
        jee.toggleCreateDefaultModules(false);
        WebProjectWizard ww = jee.addWeb();
        WebProjectFirstPage wp = new WebProjectFirstPage((WizardDialog)ww);
        wp.setProjectName("CreatedWebProjectModule");
        ww.finish();
        ear.finish();
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.open();
        Assert.assertTrue((boolean)explorer.containsProject(this.projectName));
        Assert.assertTrue((boolean)explorer.containsProject("CreatedWebProjectModule"));
    }
}

