/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.browser;

import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class BrowserViewTest {
    protected static WebBrowserView browserView;
    protected static final String FIRST_PAGE = "https://www.google.cz/?q=redhat";
    protected static final String SECOND_PAGE = "https://www.google.cz/?q=jboss";

    @Before
    public void openBrowser() {
        browserView = new WebBrowserView();
        browserView.open();
    }

    @After
    public void closeBrowser() {
        browserView.close();
    }

    @Test
    public void testNavigation() {
        browserView.openPageURL(FIRST_PAGE);
        browserView.openPageURL(SECOND_PAGE);
        browserView.back();
        this.assertPageIsOpened(FIRST_PAGE);
        browserView.forward();
        this.assertPageIsOpened(SECOND_PAGE);
    }

    @Test
    public void testRefreshPage() {
        browserView.openPageURL(FIRST_PAGE);
        browserView.refreshPage();
        this.assertPageIsOpened(FIRST_PAGE);
    }

    private void assertPageIsOpened(String url) {
        Assert.assertTrue((boolean)browserView.getPageURL().contains(url));
    }
}

