/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.util.List;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ServersViewTest
extends ServersViewTestCase {
    @Override
    public void tearDown() {
        super.tearDown();
        for (Server server : ServersViewTest.getServersView().getServers()) {
            server.delete(false);
        }
    }

    @Test
    public void newServer() {
        wizardDialog = ServersViewTest.getServersView().newServer();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)"New Server"));
    }

    @Test
    public void getServers_noServers() {
        List servers = ServersViewTest.getServersView().getServers();
        Assert.assertThat((Object)servers.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void getServers() {
        ServersViewTest.createServer("Server AB");
        ServersViewTest.createServer("Server A");
        List servers = ServersViewTest.getServersView().getServers();
        Assert.assertThat((Object)servers.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Server)servers.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"Server A"));
        Assert.assertThat((Object)((Server)servers.get(1)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"Server AB"));
    }

    @Test(expected=EclipseLayerException.class)
    public void getServer_noServers() {
        ServersViewTest.getServersView().getServer("Server A");
    }

    @Test(expected=EclipseLayerException.class)
    public void getServer_notFound() {
        ServersViewTest.createServer("Server AB");
        ServersViewTest.getServersView().getServer("Server A");
    }

    @Test
    public void getServer() {
        ServersViewTest.createServer("Server AB");
        ServersViewTest.createServer("Server A");
        Server server = ServersViewTest.getServersView().getServer("Server A");
        Assert.assertNotNull((Object)server);
        Assert.assertThat((Object)server.getLabel().getName(), (Matcher)CoreMatchers.is((Object)"Server A"));
    }
}

