/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.wizard;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.wst.server.ui.Runtime;
import org.eclipse.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardPage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class NewRuntimeWizardPageTest {
    private RuntimePreferencePage preference;
    private NewRuntimeWizardDialog wizard;
    private NewRuntimeWizardPage wizardPage;
    private WorkbenchPreferenceDialog workbenchPreferencesDialog;

    @Before
    public void setUp() {
        this.workbenchPreferencesDialog = new WorkbenchPreferenceDialog();
        this.workbenchPreferencesDialog.open();
        this.preference = new RuntimePreferencePage((ReferencedComposite)this.workbenchPreferencesDialog);
        this.workbenchPreferencesDialog.select((PreferencePage)this.preference);
        this.preference.removeAllRuntimes();
        this.wizard = this.preference.addRuntime();
        this.wizardPage = new NewRuntimeWizardPage((ReferencedComposite)this.wizard);
    }

    @Test
    public void selectType() {
        this.wizardPage.selectType(new String[]{"Basic", "Test runtime"});
        this.wizard.finish();
        List runtimes = this.preference.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Runtime)runtimes.get(0)).getType(), (Matcher)CoreMatchers.is((Object)"Test runtime"));
    }

    @After
    public void tearDown() {
        if (this.workbenchPreferencesDialog != null) {
            this.preference.removeAllRuntimes();
            this.workbenchPreferencesDialog.cancel();
        }
    }
}

