/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.xml.ui.tabletree;

import java.io.File;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.test.ui.part.MultiPageEditorTest;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLEditorFile;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLMultiPageEditorPart;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLSourcePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class XMLSourcePageTest {
    public static final File ZIP_FILE = new File(Activator.getTestResourcesLocation(MultiPageEditorTest.class), "xml-project.zip");
    protected static final String PROJECT_NAME = "xml-project";
    protected static final String FILE_NAME = "file.xml";
    protected static final String NAMESPACES_FILE_NAME = "TomcatServerRequirement.xml";
    private static PackageExplorerPart explorer;

    @BeforeClass
    public static void importProject() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT_NAME});
        wizard.finish();
        explorer = new PackageExplorerPart();
        explorer.open();
    }

    @AfterClass
    public static void cleanProject() {
        explorer.open();
        explorer.getProject(PROJECT_NAME).delete(true);
    }

    @Test
    public void evaluateXPath() {
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{FILE_NAME}).open();
        XMLMultiPageEditorPart editor = new XMLMultiPageEditorPart(FILE_NAME);
        XMLSourcePage page = editor.getSourcePage();
        XMLEditorFile xmlEditorFile = page.getAssociatedFile();
        String result = xmlEditorFile.xpath("/a/b1/c/text()");
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"content"));
    }

    @Test
    public void evaluateXPathWithNamespace() {
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{NAMESPACES_FILE_NAME}).openWith("XML Editor");
        XMLMultiPageEditorPart editor = new XMLMultiPageEditorPart(NAMESPACES_FILE_NAME);
        XMLSourcePage page = editor.getSourcePage();
        XMLEditorFile xmlEditorFile = page.getAssociatedFile();
        String result = xmlEditorFile.xpath("/:testrun/:requirements/server:server-requirement/@name");
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"Tomcat7"));
    }

    @Test
    public void evaluateXPathWithIgnoringNamespace() {
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{NAMESPACES_FILE_NAME}).openWith("XML Editor");
        XMLMultiPageEditorPart editor = new XMLMultiPageEditorPart(NAMESPACES_FILE_NAME);
        XMLSourcePage page = editor.getSourcePage();
        XMLEditorFile xmlEditorFile = page.getAssociatedFile();
        String result = xmlEditorFile.xpath("/testrun/requirements/server-requirement/@name", false);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"Tomcat7"));
    }
}

