/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.datatools.connectivity.ui.dialogs;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverDefinition;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverTemplate;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.list.DefaultList;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tab.DefaultTabItem;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.swt.widgets.List;
import org.hamcrest.Matcher;

public class DriverDialog
extends DefaultShell {
    public static final String WIZARD_TITLE = "New Driver Definition";
    public static final String LABEL_DRIVER_CLASS = "Driver Class";
    public static final String LABEL_DRIVER_NAME = "Driver name:";
    public static final String TAB_NAME_TYPE = "Name/Type";
    public static final String TAB_PROPERTIES = "Properties";
    public static final String TAB_JAR_LIST = "JAR List";
    public static final String BUTTON_CLEAR_ALL = "Clear All";
    public static final String BUTTON_REMOVE_JAR = "Remove JAR/Zip";
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public void create(DriverDefinition driverDefinition) {
        DriverTemplate drvTemp = driverDefinition.getDriverTemplate();
        this.selectDriverTemplate(drvTemp.getType(), drvTemp.getVersion());
        this.setName(driverDefinition.getDriverName());
        this.addDriverLibrary(driverDefinition.getDriverLibrary());
        this.ok();
    }

    public void ok() {
        new OkButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
    }

    public void setName(String name) {
        new LabeledText(LABEL_DRIVER_NAME).setText(name);
    }

    public void selectDriverTemplate(String type, String version) {
        this.selectTab(TAB_NAME_TYPE);
        DefaultTree tree = new DefaultTree();
        TreeItem root = (TreeItem)tree.getItems().get(0);
        for (TreeItem item : root.getItems()) {
            if (!type.equals(item.getCell(0)) || !version.equals(item.getCell(2))) continue;
            item.select();
            break;
        }
    }

    public void setDriverClass(String driverClass) {
        this.selectTab(TAB_PROPERTIES);
        new DefaultTreeItem(new String[]{"General", LABEL_DRIVER_CLASS}).doubleClick();
        new PushButton("...").click();
        String dlgTitle = "Available Classes from Jar List";
        new WaitUntil((WaitCondition)new ShellIsAvailable(dlgTitle));
        new DefaultShell(dlgTitle);
        new RadioButton(0, new Matcher[0]).click();
        new DefaultText("").setText(driverClass);
        new OkButton().click();
    }

    public void addDriverLibrary(String driverLocation) {
        this.selectTab(TAB_JAR_LIST);
        this.clearAllDriverLibraries();
        this.addItem(driverLocation);
        this.addItem(driverLocation);
        this.removeDriverLibrary(driverLocation);
    }

    public void removeDriverLibrary(String driverLocation) {
        new DefaultList().select(driverLocation);
        new PushButton(BUTTON_REMOVE_JAR).click();
    }

    public void clearAllDriverLibraries() {
        if (new DefaultList().getListItems().length > 0) {
            new PushButton(BUTTON_CLEAR_ALL).click();
        } else {
            this.log.info("No drivers to clean, skipped");
        }
    }

    public void selectTab(String label) {
        new DefaultTabItem(label).activate();
    }

    private void addItem(String item) {
        new ExtendedDeafultList().addItem(item);
    }

    private class ExtendedDeafultList
    extends DefaultList {
        public void addItem(final String item) {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((List)ExtendedDeafultList.this.swtWidget).add(item);
                }
            });
        }
    }
}

