/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.integration.test.installation.common.dialog.InstallNewSoftwareDialog;
import org.eclipse.reddeer.integration.test.installation.common.page.AvailableSoftwarePage;
import org.eclipse.reddeer.integration.test.installation.common.preferences.AvailableSoftwareSitesPreferencePage;
import org.eclipse.reddeer.integration.test.installation.common.util.InstallationOperator;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class InstallSoftwareFromUpdateSiteTest {
    private static final String UPDATE_SITE = System.getProperty("update.site");
    private static final String P2_ONLY_PROP = "p2.only";
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @BeforeClass
    public static void prepareTestEnv() {
        if (Boolean.getBoolean(P2_ONLY_PROP)) {
            System.out.println("System prop. p2.only: " + Boolean.getBoolean(P2_ONLY_PROP));
            WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
            dialog.open();
            AvailableSoftwareSitesPreferencePage page = new AvailableSoftwareSitesPreferencePage((ReferencedComposite)dialog);
            dialog.select((PreferencePage)page);
            int i = 0;
            while (i < page.getItems().size()) {
                page.getItems().get(0).select();
                page.clickRemove();
                DefaultShell removeSites = new DefaultShell("Remove Sites");
                new PushButton("Yes").click();
                new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)removeSites), TimePeriod.SHORT);
                ++i;
            }
            dialog.ok();
        }
    }

    @Test
    public void testInstallFromUpdateSite() {
        try {
            new URL(UPDATE_SITE);
        }
        catch (MalformedURLException malformedURLException) {
            Assert.fail((String)("Invalid update site URL: '" + UPDATE_SITE + "'"));
        }
        InstallNewSoftwareDialog installDialog = new InstallNewSoftwareDialog();
        installDialog.open();
        AvailableSoftwarePage installPage = new AvailableSoftwarePage(installDialog);
        installPage.addUpdateSite(UPDATE_SITE);
        installPage.selectSoftware(".*RedDeer.*");
        installDialog.next();
        new InstallationOperator(installDialog, this.collector).completeInstallation();
    }
}

