/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.requirement.configuration;

import java.util.List;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.configuration.RedDeerConfigurationException;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfigurationPool;
import org.eclipse.reddeer.junit.test.internal.configuration.reader.JSONConfigurationReaderTest;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.ComplexConfiguration;
import org.eclipse.reddeer.junit.test.requirement.configuration.resources.SimpleConfiguration;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequirementConfigurationPoolTest {
    @Before
    public void setup() {
        RequirementConfigurationPool.destroyPool();
    }

    @Test(expected=RedDeerConfigurationException.class)
    public void testGetConfigurationsFromConfigPoolWithNonexistingConfigFile() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.NONEXISTING_FILE);
        RequirementConfigurationPool.getInstance();
    }

    @Test(expected=RedDeerConfigurationException.class)
    public void testGetNonexistingConfigurationFile() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.NONEXISTING_FILE);
        RequirementConfigurationPool.getConfigurationFile();
        RequirementConfigurationPool.getInstance();
    }

    @Test(expected=RedDeerConfigurationException.class)
    public void testGetInvalidConfigurationFile() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.INVALID_FILE);
        RequirementConfigurationPool.getConfigurationFile();
        RequirementConfigurationPool.getInstance();
    }

    @Test
    public void testGetConfigurationFile() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.CONFIG_FILE);
        Assert.assertNotNull((String)"Configuration file should not be null", (Object)RequirementConfigurationPool.getConfigurationFile());
    }

    @Test
    public void getRequirementConfigurationsFromPool() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.CONFIG_FILE);
        int configAmount = RequirementConfigurationPool.getInstance().getRequirementsConfigurations().size();
        MatcherAssert.assertThat((String)("There should be 8 configurations in configuration pool, but there is/are " + configAmount + " configs"), (configAmount == 8 ? 1 : 0) != 0);
    }

    @Test
    public void getSimpleRequirementConfigurationsFromPool() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.CONFIG_FILE);
        int size = RequirementConfigurationPool.getInstance().getConfigurations(SimpleConfiguration.class).size();
        MatcherAssert.assertThat((String)("There should be 5 simple requirement configurations, but there are " + size), (size == 5 ? 1 : 0) != 0);
    }

    @Test
    public void getComplexRequirementConfigurationsFromPool() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.CONFIG_FILE);
        List list = RequirementConfigurationPool.getInstance().getConfigurations(ComplexConfiguration.class);
        MatcherAssert.assertThat((String)("There should be 3 complex requirement configurations, but there are " + list.size()), (list.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void getSimpleRequirementConfigurationsFromPoolYAML() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.CONFIG_FILE_YAML);
        int size = RequirementConfigurationPool.getInstance().getConfigurations(SimpleConfiguration.class).size();
        MatcherAssert.assertThat((String)("There should be 5 simple requirement configurations, but there are " + size), (size == 5 ? 1 : 0) != 0);
    }

    @Test
    public void getComplexRequirementConfigurationsFromPoolYAML() {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), JSONConfigurationReaderTest.CONFIG_FILE_YAML);
        List list = RequirementConfigurationPool.getInstance().getConfigurations(ComplexConfiguration.class);
        MatcherAssert.assertThat((String)("There should be 3 complex requirement configurations, but there are " + list.size()), (list.size() == 3 ? 1 : 0) != 0);
    }

    @After
    public void cleanup() {
        System.clearProperty(RedDeerProperties.CONFIG_FILE.getName());
        RequirementConfigurationPool.destroyPool();
    }
}

