/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class TreeRule
extends AbstractSimpleRedDeerRule {
    private List<ReferencedComposite> composites;
    private int treeIndex;
    private String itemText;
    private List<String> parents;
    private boolean check;
    private boolean checkDetail;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Tree && event.item instanceof TreeItem && event.type == 13;
    }

    public void initializeForEvent(Event event) {
        CTabItem v;
        Widget w;
        this.widget = w = event.widget;
        LinkedList<Widget> parentz = new LinkedList<Widget>();
        while (w != null) {
            parentz.add(w);
            w = ((Composite)w).getParent();
        }
        Collections.reverse(parentz);
        this.setComposites(RedDeerUtils.getComposites((Control)((Tree)event.widget)));
        this.treeIndex = WidgetUtils.getIndex((Control)((Tree)event.widget));
        this.itemText = WidgetUtils.cleanText((String)((TreeItem)event.item).getText());
        Shell s = WidgetUtils.getShell((Control)((Tree)event.widget));
        if (s != null) {
            this.setShellTitle(s.getText());
        }
        if ((v = RedDeerUtils.getView((Control)((Tree)event.widget))) != null) {
            this.setViewTitle(v.getText());
        }
        TreeItem parent = ((TreeItem)event.item).getParentItem();
        this.parents = new ArrayList<String>();
        while (parent != null) {
            this.parents.add(WidgetUtils.cleanText((String)parent.getText()));
            parent = parent.getParentItem();
        }
        Collections.reverse(this.parents);
        this.checkDetail = event.detail == 32;
        if (this.checkDetail) {
            this.check = ((TreeItem)event.item).getChecked();
        }
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder res = new StringBuilder();
        res.append("new DefaultTreeItem(");
        res.append(RedDeerUtils.getReferencedCompositeString(this.composites));
        if (this.treeIndex != 0) {
            res.append(String.valueOf(this.treeIndex) + ",");
        }
        for (String parent : this.parents) {
            res.append("\"" + parent + "\",");
        }
        res.append("\"" + this.itemText + "\")");
        if (this.checkDetail) {
            res.append(".setChecked(" + this.check + ")");
        } else {
            res.append(".select()");
        }
        toReturn.add(res.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem");
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public int getTreeIndex() {
        return this.treeIndex;
    }

    public void setTreeIndex(int treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getItemText() {
        return this.itemText;
    }

    public void setItemText(String itemText) {
        this.itemText = itemText;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }
}

