/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.vprop;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class Property
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(WSDL_ND_DEFINITIONS);
    String ncName;
    protected String fTypeName;
    protected String fElementName;

    @Override
    public void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_NAME);
    }

    @ARule(sa=0, desc="Check the NCName of the property", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        if (!this.checkNCName(this.mNode, this.ncName, AT_NAME)) {
            this.disableRules();
        }
    }

    @ARule(sa=0, desc="Check if property name is duplicated", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC__DUPLICATE")
    public void rule_CheckDuplicateName_5() {
        if (Property.isEmpty(this.ncName)) {
            return;
        }
        String key = "v.property." + this.ncName;
        if (this.containsValueKey(this.fParentNode, key)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__DUPLICATE", this.toString(this.mNode.nodeName()), this.ncName);
            return;
        }
        this.setValue(this.fParentNode, key, true);
    }

    @ARule(sa=19, desc="Either the type or element attributes MUST be present but not both.", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass1", errors="BPELC_PROPERTY__UNSET")
    public void rule_CheckPropertyType_10() {
        this.fTypeName = this.mNode.getAttribute(AT_TYPE);
        this.fElementName = this.mNode.getAttribute(AT_ELEMENT);
        if (Property.isEmpty(this.fTypeName) && Property.isEmpty(this.fElementName) || Property.isNonEmpty(this.fTypeName) && Property.isNonEmpty(this.fElementName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PROPERTY__UNSET", this.toString(this.mNode.nodeName()), AT_TYPE, AT_ELEMENT, 0);
            this.disableRules();
        }
    }

    @ARule(desc="Attribute cannot be resolved for XSD type or element.", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass1", errors="BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_CheckTypeOrElement_15() {
        INode typeNode = null;
        if (!Property.isEmpty(this.fTypeName)) {
            typeNode = this.mModelQuery.lookup(this.mNode.rootNode(), 9, this.fTypeName);
            if (this.isUndefined(typeNode)) {
                IProblem problem = this.createError();
                problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_TYPE, 0, this.fTypeName);
            }
        } else if (!Property.isEmpty(this.fElementName) && this.isUndefined(typeNode = this.mModelQuery.lookup(this.mNode.rootNode(), 8, this.fElementName))) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_ELEMENT, 0, this.fElementName);
        }
    }
}

