/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.Messages;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

class CMakeErrorParser
extends ConsoleOutputStream {
    public static final String CMAKE_PROBLEM_MARKER_ID = String.valueOf(Activator.getId()) + ".cmakeproblem";
    private static final String START_DERROR = "CMake Deprecation Error";
    private static final String START_DWARNING = "CMake Deprecation Warning";
    private static final String START_ERROR = "CMake Error";
    private static final String START_ERROR_DEV = "CMake Error (dev)";
    private static final String START_IERROR = "CMake Internal Error (please report a bug)";
    private static final String START_LOG = "CMake Debug Log";
    private static final String START_WARNING = "CMake Warning";
    private static final String START_WARNING_DEV = "CMake Warning (dev)";
    private static final String START_STATUS = "--";
    private static final String START_MSG_SIMPLE = "\\R\\R";
    private static final Pattern PTN_MSG_START;
    private static final String GP_FILE = "File";
    private static final String GP_LINE = "Lineno";
    private final IContainer srcPath;
    private final OutputStream os;
    private final StringBuilder buffer;
    private boolean somSeen;

    static {
        String ptn = "^" + String.join((CharSequence)"|", START_DERROR, START_DWARNING, Pattern.quote(START_ERROR_DEV), START_ERROR, Pattern.quote(START_IERROR), START_LOG, Pattern.quote(START_WARNING_DEV), START_WARNING, START_STATUS, START_MSG_SIMPLE);
        PTN_MSG_START = Pattern.compile(ptn);
    }

    public CMakeErrorParser(IContainer srcFolder, OutputStream outputStream) {
        this.srcPath = Objects.requireNonNull(srcFolder);
        this.os = outputStream;
        this.buffer = new StringBuilder(512);
    }

    private void processBuffer(boolean isEOF) {
        block3: {
            Matcher matcher = PTN_MSG_START.matcher("");
            while (true) {
                matcher.reset(this.buffer);
                if (!matcher.find()) break;
                if (!this.somSeen) {
                    this.buffer.delete(0, matcher.start());
                    this.somSeen = true;
                    return;
                }
                String classification = matcher.group();
                int start = matcher.end();
                if (matcher.find() || isEOF) {
                    int end = isEOF ? this.buffer.length() : matcher.start();
                    String fullMessage = this.buffer.substring(0, end);
                    String content = this.buffer.substring(start, end);
                    this.processMessage(classification, content, fullMessage);
                    this.buffer.delete(0, end);
                    continue;
                }
                break block3;
                break;
            }
            return;
        }
    }

    private void processMessage(String classification, String content, String fullMessage) {
        MarkerCreator creator;
        switch (classification) {
            case "CMake Deprecation Error": {
                creator = new McDeprError(this.srcPath);
                break;
            }
            case "CMake Deprecation Warning": {
                creator = new McDeprWarning(this.srcPath);
                break;
            }
            case "CMake Error": {
                creator = new McError(this.srcPath);
                break;
            }
            case "CMake Error (dev)": {
                creator = new McErrorDev(this.srcPath);
                break;
            }
            case "CMake Internal Error (please report a bug)": {
                creator = new McInternalError(this.srcPath);
                break;
            }
            case "CMake Warning": {
                creator = new McWarning(this.srcPath);
                break;
            }
            case "CMake Warning (dev)": {
                creator = new McWarningDev(this.srcPath);
                break;
            }
            default: {
                return;
            }
        }
        try {
            creator.createMarker(fullMessage, content);
        }
        catch (CoreException e) {
            Activator.getPlugin().getLog().log((IStatus)new Status(2, Activator.getId(), "CMake output error parsing failed", (Throwable)e));
        }
    }

    public void write(int c) throws IOException {
        if (this.os != null) {
            this.os.write(c);
        }
        this.buffer.append(new String(new byte[]{(byte)c}));
        this.processBuffer(false);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.os != null) {
            this.os.write(b, off, len);
        }
        this.buffer.append(new String(b, off, len));
        this.processBuffer(false);
    }

    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
        this.processBuffer(true);
    }

    private static abstract class MarkerCreator {
        private static final Pattern[] PTN_LOCATION = new Pattern[]{Pattern.compile("(?m)^ at (?<File>.+):(?<Lineno>\\d+).*$"), Pattern.compile("(?s)^: Error in cmake code at.(?<File>.+):(?<Lineno>\\d+).*$"), Pattern.compile("(?m)^ in (?<File>.+):(?<Lineno>\\d+).*$"), Pattern.compile("(?m)^:\\s.+$")};
        protected final IContainer srcPath;

        public MarkerCreator(IContainer srcPath) {
            this.srcPath = srcPath;
        }

        abstract String getClassification();

        abstract int getSeverity();

        public void createMarker(String fullMessage, String content) throws CoreException {
            Pattern[] patternArray = PTN_LOCATION;
            int n = PTN_LOCATION.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern ptn = patternArray[n2];
                Matcher matcher = ptn.matcher(content);
                if (matcher.find()) {
                    String filename = null;
                    try {
                        filename = matcher.group(CMakeErrorParser.GP_FILE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    IMarker marker = this.createBasicMarker(filename, this.getSeverity(), fullMessage.trim());
                    try {
                        String lineno = matcher.group(CMakeErrorParser.GP_LINE);
                        Integer lineNumber = Integer.parseInt(lineno);
                        marker.setAttribute("lineNumber", (Object)lineNumber);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                ++n2;
            }
        }

        protected final IMarker createBasicMarker(String fileName, int severity, String fullMessage) throws CoreException {
            IMarker marker;
            if (fileName == null) {
                marker = this.srcPath.createMarker(CMAKE_PROBLEM_MARKER_ID);
            } else {
                Path path = new Path(fileName);
                try {
                    marker = this.srcPath.getFile((IPath)path).createMarker(CMAKE_PROBLEM_MARKER_ID);
                }
                catch (CoreException ign) {
                    IPath srcLocation = this.srcPath.getLocation();
                    if (srcLocation.isPrefixOf((IPath)path)) {
                        int segmentsToRemove = srcLocation.segmentCount();
                        path = path.removeFirstSegments(segmentsToRemove);
                        marker = this.srcPath.getFile((IPath)path).createMarker(CMAKE_PROBLEM_MARKER_ID);
                    }
                    marker = this.srcPath.createMarker(CMAKE_PROBLEM_MARKER_ID);
                    Activator.getPlugin().getLog().log((IStatus)new Status(1, Activator.getId(), String.format(Messages.CMakeErrorParser_NotAWorkspaceResource, fileName)));
                }
            }
            marker.setAttribute("message", (Object)fullMessage);
            marker.setAttribute("severity", severity);
            marker.setAttribute("location", (Object)CMakeErrorParser.class.getName());
            return marker;
        }
    }

    private static class McDeprError
    extends MarkerCreator {
        public McDeprError(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_DERROR;
        }

        @Override
        int getSeverity() {
            return 2;
        }
    }

    private static class McDeprWarning
    extends MarkerCreator {
        public McDeprWarning(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_DWARNING;
        }

        @Override
        int getSeverity() {
            return 1;
        }
    }

    private static class McError
    extends MarkerCreator {
        public McError(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_ERROR;
        }

        @Override
        int getSeverity() {
            return 2;
        }
    }

    private static class McErrorDev
    extends MarkerCreator {
        public McErrorDev(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_ERROR_DEV;
        }

        @Override
        int getSeverity() {
            return 2;
        }
    }

    private static class McInternalError
    extends MarkerCreator {
        public McInternalError(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_IERROR;
        }

        @Override
        int getSeverity() {
            return 2;
        }
    }

    private static class McWarning
    extends MarkerCreator {
        public McWarning(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_WARNING;
        }

        @Override
        int getSeverity() {
            return 1;
        }
    }

    private static class McWarningDev
    extends MarkerCreator {
        public McWarningDev(IContainer srcPath) {
            super(srcPath);
        }

        @Override
        String getClassification() {
            return CMakeErrorParser.START_WARNING_DEV;
        }

        @Override
        int getSeverity() {
            return 1;
        }
    }
}

