/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core.participant;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.cmake.is.core.participant.IToolCommandlineParser;
import org.eclipse.cdt.cmake.is.core.participant.IToolDetectionParticipant;

public class DefaultToolDetectionParticipant
implements IToolDetectionParticipant {
    protected static final String REGEX_GROUP_CMD = "cmd";
    protected static final String REGEX_CMD_PATH_SLASH = String.format(Locale.ROOT, "\\A(?<%s>(\\S*?%s)?", "cmd", "/");
    protected static final String REGEX_CMD_PATH_SLASH_END = ")\\s";
    protected static final String REGEX_CMD_PATH_SLASH_QUOTE = String.format(Locale.ROOT, "\\A([\"'])(?<%s>((?:(?!\\1).)*?%s)", "cmd", "/");
    protected static final String REGEX_CMD_PATH_SLASH_QUOTE_END = ")\\1\\s";
    protected static final String REGEX_CMD_PATH_BSLASH = String.format(Locale.ROOT, "\\A(?<%s>(\\S*?%s)?", "cmd", "\\\\");
    protected static final String REGEX_CMD_PATH_BSLASH_END = ")\\s";
    protected static final String REGEX_CMD_PATH_BSLASH_QUOTE = String.format(Locale.ROOT, "\\A([\"'])(?<%s>((?:(?!\\1).)*?%s)?", "cmd", "\\\\");
    protected static final String REGEX_CMD_PATH_BSLASH_QUOTE_END = ")\\1\\s";
    private final Matcher[] toolNameMatchers;
    private final Matcher[] toolNameMatchersBackslash;
    protected final Matcher[] toolNameMatchersExt;
    protected final Matcher[] toolNameMatchersExtBackslash;
    private final IToolCommandlineParser parser;
    protected final String basenameRegex;
    protected final String extensionRegex;
    protected final boolean alsoHandleNtfsPaths;

    public DefaultToolDetectionParticipant(String basenameRegex, IToolCommandlineParser parser) {
        this(basenameRegex, false, parser);
    }

    public DefaultToolDetectionParticipant(String basenameRegex, boolean alsoHandleNtfsPaths, IToolCommandlineParser parser) {
        this(basenameRegex, alsoHandleNtfsPaths, null, parser);
    }

    public DefaultToolDetectionParticipant(String basenameRegex, String extensionRegex, IToolCommandlineParser parser) {
        this(basenameRegex, false, extensionRegex, parser);
    }

    public DefaultToolDetectionParticipant(String basenameRegex, boolean alsoHandleNtfsPaths, String extensionRegex, IToolCommandlineParser parser) {
        this.basenameRegex = basenameRegex;
        this.parser = parser;
        this.alsoHandleNtfsPaths = alsoHandleNtfsPaths;
        this.extensionRegex = extensionRegex;
        this.toolNameMatchers = new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_SLASH_QUOTE, basenameRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_SLASH, basenameRegex, ")\\s")).matcher("")};
        this.toolNameMatchersBackslash = alsoHandleNtfsPaths ? new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, basenameRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_BSLASH, basenameRegex, ")\\s")).matcher("")} : new Matcher[0];
        if (extensionRegex != null) {
            this.toolNameMatchersExt = new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_SLASH_QUOTE, basenameRegex, extensionRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_SLASH, basenameRegex, extensionRegex, ")\\s")).matcher("")};
            this.toolNameMatchersExtBackslash = alsoHandleNtfsPaths ? new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, basenameRegex, extensionRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH, basenameRegex, extensionRegex, ")\\s")).matcher("")} : new Matcher[0];
        } else {
            this.toolNameMatchersExt = new Matcher[0];
            this.toolNameMatchersExtBackslash = new Matcher[0];
        }
    }

    @Override
    public IToolCommandlineParser getParser() {
        return this.parser;
    }

    @Override
    public boolean canHandleNtfsPaths() {
        return this.alsoHandleNtfsPaths;
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameMatches(String commandLine, boolean matchBackslash) {
        if (matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Matcher[] matcherArray = matchBackslash ? this.toolNameMatchersBackslash : this.toolNameMatchers;
        int n = matcherArray.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher matcher = matcherArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.matcherMatches(matcher, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameWithVersionMatches(String commandLine, boolean matchBackslash, String versionRegex) {
        if (matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Matcher[] toolNameMatchers = matchBackslash ? new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, this.basenameRegex, versionRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_BSLASH, this.basenameRegex, versionRegex, ")\\s")).matcher("")} : new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_SLASH_QUOTE, this.basenameRegex, versionRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_SLASH, this.basenameRegex, versionRegex, ")\\s")).matcher("")};
        Matcher[] matcherArray = toolNameMatchers;
        int n = toolNameMatchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher matcher = matcherArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.matcherMatches(matcher, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameWithExtensionMatches(String commandLine, boolean matchBackslash) {
        if (matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Matcher[] matcherArray = matchBackslash ? this.toolNameMatchersExtBackslash : this.toolNameMatchersExt;
        int n = matcherArray.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher matcher = matcherArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.matcherMatches(matcher, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameWithVersionAndExtensionMatches(String commandLine, boolean matchBackslash, String versionRegex) {
        if (this.extensionRegex == null || matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Matcher[] toolNameMatchers = matchBackslash ? new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, this.basenameRegex, versionRegex, this.extensionRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH, this.basenameRegex, versionRegex, this.extensionRegex, ")\\s")).matcher("")} : new Matcher[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_SLASH_QUOTE, this.basenameRegex, versionRegex, this.extensionRegex, ")\\1\\s")).matcher(""), Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_SLASH, this.basenameRegex, versionRegex, this.extensionRegex, ")\\s")).matcher("")};
        Matcher[] matcherArray = toolNameMatchers;
        int n = toolNameMatchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher matcher = matcherArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.matcherMatches(matcher, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    private Optional<IToolDetectionParticipant.MatchResult> matcherMatches(Matcher matcher, String commandLine) {
        matcher.reset(commandLine);
        if (matcher.lookingAt()) {
            return Optional.of(new IToolDetectionParticipant.MatchResult(matcher.group(REGEX_GROUP_CMD), commandLine.substring(matcher.end())));
        }
        return Optional.empty();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [basenameRegex=" + this.basenameRegex + ", extensionRegex=" + this.extensionRegex + "]";
    }
}

