/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.dap.gdbjtag;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.dap.DapLaunchDelegate;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.DefaultGDBJtagDeviceImpl;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DapGdbJtagLaunchDelegate
extends DapLaunchDelegate {
    public static final String TARGET = "target";
    public static final String TYPE = "type";
    public static final String PARAMETERS = "parameters";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String CONNECT_COMMANDS = "connectCommands";
    public static final String IMAGE_AND_SYMBOLS = "imageAndSymbols";
    public static final String SYMBOL_FILE_NAME = "symbolFileName";
    public static final String SYMBOL_OFFSET = "symbolOffset";
    public static final String IMAGE_FILE_NAME = "imageFileName";
    public static final String IMAGE_OFFSET = "imageOffset";
    public static final String PRE_RUN_COMMANDS = "preRunCommands";
    private static final String ATTR_JTAG_DEVICE = "org.eclipse.cdt.debug.gdbjtag.core.jtagDevice";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, boolean targetDebugAdapter, Map<String, Object> params) throws CoreException {
        params.put("request", "attach");
        HashMap<String, Object> target = new HashMap<String, Object>();
        params.put(TARGET, target);
        Map attributes = configuration.getAttributes();
        IGDBJtagDevice jtagDevice = this.getJtagDevice(attributes);
        this.addTargetCommands(target, jtagDevice, attributes);
        this.addInitCommands(params, jtagDevice, attributes);
        this.addImageAndSymbols(params, jtagDevice, configuration, attributes);
        this.addPreRunCommands(params, jtagDevice, attributes);
        super.launch(configuration, mode, launch, monitor, true, params);
    }

    private void addImageAndSymbols(Map<String, Object> params, IGDBJtagDevice jtagDevice, ILaunchConfiguration configuration, Map<String, Object> attributes) throws CoreException {
        HashMap<String, String> imageAndSymbols;
        block21: {
            ArrayList defaultCommands;
            DefaultGDBJtagDeviceImpl defaultGDBJtagDeviceImpl;
            ArrayList commands;
            String programFile;
            block20: {
                imageAndSymbols = null;
                try {
                    if (!((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", (Object)true)).booleanValue()) break block20;
                    String symbolsFileName = null;
                    if (attributes.containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && ((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", (Object)true)).booleanValue()) {
                        programFile = LaunchUtils.getProgramPath((ILaunchConfiguration)configuration);
                        if (programFile != null) {
                            symbolsFileName = programFile;
                        }
                    } else {
                        symbolsFileName = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", (Object)"");
                        symbolsFileName = symbolsFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName) : null;
                    }
                    if (symbolsFileName == null) {
                        throw this.newCoreException("Symbolics loading was requested but file was not specified or not found.");
                    }
                    String symbolsOffset = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", (Object)"");
                    if (symbolsOffset != null && symbolsOffset.length() > 0) {
                        symbolsOffset = "0x" + symbolsOffset;
                    }
                    commands = new ArrayList();
                    jtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
                    defaultGDBJtagDeviceImpl = new DefaultGDBJtagDeviceImpl();
                    defaultCommands = new ArrayList();
                    defaultGDBJtagDeviceImpl.doLoadSymbol(symbolsFileName, symbolsOffset, defaultCommands);
                    if (commands.equals(defaultCommands)) {
                        imageAndSymbols = new HashMap<String, String>();
                        imageAndSymbols.put(SYMBOL_FILE_NAME, symbolsFileName);
                        if (symbolsOffset != null && symbolsOffset.length() > 0) {
                            imageAndSymbols.put(SYMBOL_OFFSET, symbolsOffset);
                        }
                        break block20;
                    }
                    throw this.newCoreException(String.format("Device '%s' has non-standard method for loading symbol table which is not supported by the debug adapter.", this.getGDBJtagDeviceName(attributes)));
                }
                catch (CoreException e) {
                    throw this.newCoreException("Cannot load symbol", e);
                }
            }
            try {
                String imageFileName = null;
                if (!((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue()) break block21;
                if (attributes.containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && ((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", (Object)true)).booleanValue()) {
                    programFile = LaunchUtils.getProgramPath((ILaunchConfiguration)configuration);
                    if (programFile != null) {
                        imageFileName = programFile;
                    }
                } else {
                    imageFileName = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.imageFileName", (Object)"");
                    imageFileName = imageFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName) : null;
                }
                if (imageFileName == null) {
                    throw this.newCoreException("Image loading was requested but file was not specified or not found.");
                }
                String imageOffset = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                if (imageOffset != null && imageOffset.length() > 0) {
                    imageOffset = "0x" + (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                }
                commands = new ArrayList();
                jtagDevice.doLoadImage(imageFileName, imageOffset, commands);
                defaultGDBJtagDeviceImpl = new DefaultGDBJtagDeviceImpl();
                defaultCommands = new ArrayList();
                defaultGDBJtagDeviceImpl.doLoadImage(imageFileName, imageOffset, defaultCommands);
                if (commands.equals(defaultCommands)) {
                    if (imageAndSymbols == null) {
                        imageAndSymbols = new HashMap();
                    }
                    imageAndSymbols.put(IMAGE_FILE_NAME, imageFileName);
                    if (imageOffset != null && imageOffset.length() > 0) {
                        imageAndSymbols.put(IMAGE_OFFSET, imageOffset);
                    }
                    break block21;
                }
                throw this.newCoreException(String.format("Device '%s' has non-standard method for loading image which is not supported by the debug adapter.", this.getGDBJtagDeviceName(attributes)));
            }
            catch (CoreException e) {
                throw this.newCoreException("Cannot load image", e);
            }
        }
        if (imageAndSymbols != null) {
            params.put(IMAGE_AND_SYMBOLS, imageAndSymbols);
        }
    }

    private void addTargetCommands(HashMap<String, Object> target, IGDBJtagDevice jtagDevice, Map<String, Object> attributes) throws CoreException {
        if (((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", (Object)true)).booleanValue()) {
            ArrayList commands = new ArrayList();
            if (jtagDevice instanceof IGDBJtagConnection) {
                String connection = "unspecified-ip-address:unspecified-port-number";
                String connectionUri = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.connection", (Object)"unspecified-ip-address:unspecified-port-number");
                if (!"unspecified-ip-address:unspecified-port-number".equals(connectionUri)) {
                    try {
                        connection = new URI(connectionUri).getSchemeSpecificPart();
                    }
                    catch (URISyntaxException e) {
                        throw this.newCoreException("Invalid remote target connection syntax", e);
                    }
                } else {
                    String ipAddress = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.ipAddress", (Object)"unspecified-ip-address");
                    int portNumber = (Integer)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.portNumber", (Object)0);
                    if (!"unspecified-ip-address".equals(ipAddress)) {
                        connection = String.format("%s:%d", ipAddress, portNumber);
                    }
                }
                IGDBJtagConnection device = (IGDBJtagConnection)jtagDevice;
                device.doRemote(connection, commands);
            }
            target.put(CONNECT_COMMANDS, commands);
        }
    }

    private void addInitCommands(Map<String, Object> params, IGDBJtagDevice jtagDevice, Map<String, Object> attributes) throws CoreException {
        int size;
        boolean doReset = (Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.doReset", (Object)false);
        boolean doHalt = (Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.doHalt", (Object)false);
        int defaultDelay = jtagDevice.getDefaultDelay();
        int delay = (Integer)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.delay", (Object)defaultDelay);
        ArrayList resetAndHaltCommands = new ArrayList();
        jtagDevice.doResetAndHalt(resetAndHaltCommands);
        boolean useResetAndHalt = doReset && doHalt && delay == 0 && !resetAndHaltCommands.isEmpty();
        ArrayList commands = new ArrayList();
        if (doReset) {
            size = commands.size();
            if (useResetAndHalt) {
                commands.addAll(resetAndHaltCommands);
            } else {
                jtagDevice.doReset(commands);
            }
            if (size == commands.size()) {
                throw this.newCoreException(String.format("Reset command not defined for device '%s'", this.getGDBJtagDeviceName(attributes)));
            }
        }
        if (doReset && delay != 0) {
            size = commands.size();
            jtagDevice.doDelay(delay, commands);
            if (size == commands.size()) {
                throw this.newCoreException(String.format("Delay command not defined for device '%s'", this.getGDBJtagDeviceName(attributes)));
            }
        }
        if (doHalt && !useResetAndHalt) {
            size = commands.size();
            jtagDevice.doHalt(commands);
            if (size == commands.size()) {
                throw this.newCoreException(String.format("Halt command not defined for device '%s'", this.getGDBJtagDeviceName(attributes)));
            }
        }
        String userCmd = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.initCommands", (Object)"");
        try {
            userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
        }
        catch (CoreException e) {
            throw this.newCoreException(String.format("Cannot run user defined init commands", this.getGDBJtagDeviceName(attributes)));
        }
        if (userCmd.length() > 0) {
            String[] userCommandsSplit = userCmd.split("\\r?\\n");
            commands.addAll(Arrays.asList(userCommandsSplit));
        }
        if (!commands.isEmpty()) {
            params.put("initCommands", commands);
        }
    }

    private void addPreRunCommands(Map<String, Object> params, IGDBJtagDevice jtagDevice, Map<String, Object> attributes) throws CoreException {
        ArrayList<String> commands = new ArrayList<String>();
        if (((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", (Object)false)).booleanValue()) {
            String pcRegister = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.pcRegister", (Object)((String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"")));
            jtagDevice.doSetPC(pcRegister, commands);
        }
        if (((Boolean)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.setStopAt", (Object)false)).booleanValue()) {
            String stopAt = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.stopAt", (Object)"");
            jtagDevice.doStopAt(stopAt, commands);
        }
        try {
            String userCmd = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.runCommands", (Object)"");
            if (userCmd.length() > 0) {
                userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
                String[] userCommandsSplit = userCmd.split("\\r?\\n");
                commands.addAll(Arrays.asList(userCommandsSplit));
            }
        }
        catch (CoreException e) {
            throw this.newCoreException(String.format("Cannot run user defined run commands", this.getGDBJtagDeviceName(attributes)));
        }
        if (!commands.isEmpty()) {
            params.put("initCommands", commands);
        }
    }

    private IGDBJtagDevice getJtagDevice(Map<String, Object> attributes) throws CoreException {
        GDBJtagDeviceContribution deviceContribution = this.getGDBJtagDeviceContribution(attributes);
        if (deviceContribution == null) {
            throw this.newCoreException("Cannot get Jtag device information", null);
        }
        IGDBJtagDevice device = deviceContribution.getDevice();
        if (device == null) {
            throw this.newCoreException("Cannot get Jtag device instance", null);
        }
        return device;
    }

    private String getGDBJtagDeviceName(Map<String, Object> attributes) throws CoreException {
        GDBJtagDeviceContribution contribution = this.getGDBJtagDeviceContribution(attributes);
        if (contribution != null) {
            return contribution.getDeviceName();
        }
        return "";
    }

    private GDBJtagDeviceContribution getGDBJtagDeviceContribution(Map<String, Object> attributes) throws CoreException {
        String deviceName;
        String deviceId;
        if (attributes.containsKey("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId") && !(deviceId = (String)CDebugUtils.getAttribute(attributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", (Object)"")).isEmpty()) {
            return GDBJtagDeviceContributionFactory.getInstance().findByDeviceId(deviceId);
        }
        if (attributes.containsKey(ATTR_JTAG_DEVICE) && !(deviceName = (String)CDebugUtils.getAttribute(attributes, (String)ATTR_JTAG_DEVICE, (Object)"")).isEmpty()) {
            return GDBJtagDeviceContributionFactory.getInstance().findByDeviceName(deviceName);
        }
        return null;
    }

    private CoreException newCoreException(String message, Throwable e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, message, e));
    }

    private CoreException newCoreException(String message) {
        return this.newCoreException(message, null);
    }
}

