/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.branch;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.net4j.util.ObjectUtil;

public final class CDOBranchRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String branchPath;

    public CDOBranchRef() {
    }

    public CDOBranchRef(CDOBranch branch) {
        this(branch.getPathName());
    }

    public CDOBranchRef(String branchPath) {
        this.branchPath = branchPath.intern();
    }

    public CDOBranchRef(CDODataInput in) throws IOException {
        this(in.readCDOPackageURI());
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOPackageURI(this.branchPath);
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public boolean isMainBranch() {
        return "MAIN".equals(this.branchPath);
    }

    public CDOBranch resolve(CDOBranchManager branchManager) {
        return branchManager.getBranch(this.branchPath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == CDOBranchRef.class) {
            CDOBranchRef that = (CDOBranchRef)obj;
            return ObjectUtil.equals((Object)this.branchPath, (Object)that.branchPath);
        }
        return false;
    }

    public int hashCode() {
        return this.branchPath.hashCode();
    }

    public String toString() {
        return this.branchPath;
    }

    public static interface Provider {
        public CDOBranchRef getBranchRef();
    }
}

