/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.context.ContextEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesContextService {
    private Stack<ContextEntry> navigationStack = new Stack();
    private static PropertiesContextService contextService = new PropertiesContextService();

    private PropertiesContextService() {
    }

    public static PropertiesContextService getInstance() {
        return contextService;
    }

    public void push(EObject element, IPropertiesEditionComponent component) {
        this.navigationStack.push(new ContextEntry(element, component));
    }

    public void pop() {
        if (!this.navigationStack.empty()) {
            this.navigationStack.pop();
        }
    }

    public EObject entryPointElement() {
        if (!this.navigationStack.isEmpty()) {
            return ((ContextEntry)this.navigationStack.get(0)).getElement();
        }
        return null;
    }

    public IPropertiesEditionComponent entryPointComponent() {
        if (!this.navigationStack.isEmpty()) {
            return ((ContextEntry)this.navigationStack.get(0)).getPropertiesEditionComponent();
        }
        return null;
    }

    public EObject lastElement() {
        if (!this.navigationStack.isEmpty()) {
            return this.navigationStack.peek().getElement();
        }
        return null;
    }

    public IPropertiesEditionComponent lastComponent() {
        if (!this.navigationStack.isEmpty()) {
            return this.navigationStack.peek().getPropertiesEditionComponent();
        }
        return null;
    }

    public List<IPropertiesEditionComponent> getComponentsInContext(Class kind) {
        ArrayList<IPropertiesEditionComponent> result = new ArrayList<IPropertiesEditionComponent>();
        for (ContextEntry entry : this.navigationStack) {
            if (!entry.getPropertiesEditionComponent().getClass().equals(kind)) continue;
            result.add(0, entry.getPropertiesEditionComponent());
        }
        return result;
    }

    public Iterator<ContextEntry> iterator() {
        return this.navigationStack.iterator();
    }
}

