/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowComponentWithID;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.container.CompositeComponent;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.Mwe2Bridge;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;

public abstract class AbstractWorkflowComponent
implements WorkflowComponentWithID,
IWorkflowComponent {
    private static final Log log = LogFactory.getLog(AbstractWorkflowComponent.class);
    private String componentID;
    private boolean skipOnErrors = false;
    private CompositeComponent container;
    private Location location;
    private Mwe2Bridge bridge;

    public void checkRequiredConfigProperty(String configPropertyName, Object configPropertyValue, Issues issues) {
        boolean isError = false;
        if (configPropertyValue == null) {
            isError = true;
        } else if (configPropertyValue instanceof String && this.isBlank(configPropertyValue.toString())) {
            isError = true;
        }
        if (isError) {
            issues.addError("'" + configPropertyName + "' not specified.");
        }
    }

    @Override
    public String getComponentName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public CompositeComponent getContainer() {
        return this.container;
    }

    @Override
    public String getId() {
        return this.componentID;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getLogMessage() {
        return null;
    }

    @Override
    public final void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask("Running " + this.getComponentName() + "...", -1);
        }
        try {
            if (this.skipOnErrors && issues.hasErrors()) {
                log.info((Object)"execution skipped, since there are errors and skipOnErrors is set.");
                return;
            }
            this.invokeInternal(ctx, monitor, issues);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void setContainer(CompositeComponent container) {
        this.container = container;
    }

    @Override
    public void setId(String id) {
        this.componentID = id;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public void setSkipOnErrors(boolean skipOnErrors) {
        this.skipOnErrors = skipOnErrors;
    }

    protected abstract void invokeInternal(WorkflowContext var1, ProgressMonitor var2, Issues var3);

    private boolean isBlank(String string) {
        return string == null || string.trim().equals("");
    }

    protected Mwe2Bridge getBridge() {
        if (this.bridge == null) {
            this.bridge = new Mwe2Bridge(this);
        }
        return this.bridge;
    }

    public void preInvoke() {
        this.getBridge().preInvoke();
    }

    public void invoke(IWorkflowContext ctx) {
        this.getBridge().invoke(ctx);
    }

    public void postInvoke() {
        this.getBridge().postInvoke();
    }
}

