/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.core.runtime.IConfigurationElement;

import org.eclipse.epp.logging.aeri.core.ILinkable;
import org.eclipse.epp.logging.aeri.core.IServerConnection;
import org.eclipse.epp.logging.aeri.core.IUserSettings;

import org.eclipse.swt.graphics.Image;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Server Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getContributor <em>Contributor</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getClazz <em>Clazz</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon16 <em>Icon16</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon32 <em>Icon32</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConnection <em>Connection</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isConfigured <em>Configured</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isEnabled <em>Enabled</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConfigurationElement <em>Configuration Element</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor()
 * @model
 * @generated
 */
public interface IServerDescriptor extends ILinkable, IUserSettings {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Id()
	 * @model required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Contributor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Contributor</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Contributor</em>' attribute.
	 * @see #setContributor(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Contributor()
	 * @model
	 * @generated
	 */
	String getContributor();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getContributor <em>Contributor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Contributor</em>' attribute.
	 * @see #getContributor()
	 * @generated
	 */
	void setContributor(String value);

	/**
	 * Returns the value of the '<em><b>Clazz</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Clazz</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Clazz</em>' attribute.
	 * @see #setClazz(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Clazz()
	 * @model
	 * @generated
	 */
	String getClazz();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getClazz <em>Clazz</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clazz</em>' attribute.
	 * @see #getClazz()
	 * @generated
	 */
	void setClazz(String value);

	/**
	 * Returns the value of the '<em><b>Icon16</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Icon16</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Icon16</em>' attribute.
	 * @see #setIcon16(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Icon16()
	 * @model
	 * @generated
	 */
	String getIcon16();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon16 <em>Icon16</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Icon16</em>' attribute.
	 * @see #getIcon16()
	 * @generated
	 */
	void setIcon16(String value);

	/**
	 * Returns the value of the '<em><b>Icon32</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Icon32</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Icon32</em>' attribute.
	 * @see #setIcon32(String)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Icon32()
	 * @model
	 * @generated
	 */
	String getIcon32();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon32 <em>Icon32</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Icon32</em>' attribute.
	 * @see #getIcon32()
	 * @generated
	 */
	void setIcon32(String value);

	/**
	 * Returns the value of the '<em><b>Connection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Connection</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Connection</em>' attribute.
	 * @see #setConnection(IServerConnection)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Connection()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IServerConnection"
	 * @generated
	 */
	IServerConnection getConnection();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConnection <em>Connection</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Connection</em>' attribute.
	 * @see #getConnection()
	 * @generated
	 */
	void setConnection(IServerConnection value);

	/**
	 * Returns the value of the '<em><b>Configured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configured</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configured</em>' attribute.
	 * @see #setConfigured(boolean)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Configured()
	 * @model
	 * @generated
	 */
	boolean isConfigured();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isConfigured <em>Configured</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configured</em>' attribute.
	 * @see #isConfigured()
	 * @generated
	 */
	void setConfigured(boolean value);

	/**
	 * Returns the value of the '<em><b>Enabled</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Enabled</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Enabled</em>' attribute.
	 * @see #setEnabled(boolean)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_Enabled()
	 * @model default="true"
	 * @generated
	 */
	boolean isEnabled();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isEnabled <em>Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Enabled</em>' attribute.
	 * @see #isEnabled()
	 * @generated
	 */
	void setEnabled(boolean value);

	/**
	 * Returns the value of the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configuration Element</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configuration Element</em>' attribute.
	 * @see #setConfigurationElement(IConfigurationElement)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getServerDescriptor_ConfigurationElement()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IConfigurationElement"
	 * @generated
	 */
	IConfigurationElement getConfigurationElement();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConfigurationElement <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configuration Element</em>' attribute.
	 * @see #getConfigurationElement()
	 * @generated
	 */
	void setConfigurationElement(IConfigurationElement value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" dataType="org.eclipse.epp.internal.logging.aeri.ide.Image"
	 * @generated
	 */
	Image getImage16();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" dataType="org.eclipse.epp.internal.logging.aeri.ide.Image"
	 * @generated
	 */
	Image getImage32();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	boolean isActive();

} // IServerDescriptor
