/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.jaas;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.equinox.console.jaas.RolePrincipal;
import org.eclipse.equinox.console.jaas.UserPrincipal;
import org.eclipse.equinox.console.storage.DigestUtil;
import org.eclipse.equinox.console.storage.SecureUserStore;

public class SecureStorageLoginModule
implements LoginModule {
    private volatile Subject subject;
    private volatile CallbackHandler callbackHandler;
    private volatile UserPrincipal userPrincipal;
    private volatile boolean isSuccess;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (IOException | UnsupportedCallbackException exception) {
            throw new FailedLoginException("Cannot get username and password");
        }
        String username = nameCallback.getName();
        char[] password = passwordCallback.getPassword();
        this.userPrincipal = this.getUserInfo(username);
        try {
            this.isSuccess = this.userPrincipal.authenticate(DigestUtil.encrypt(new String(password)).toCharArray());
        }
        catch (Exception exception) {
            throw new FailedLoginException("Wrong credentials");
        }
        if (this.isSuccess) {
            return this.isSuccess;
        }
        throw new FailedLoginException("Wrong credentials");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() throws LoginException {
        if (this.isSuccess) {
            SecureStorageLoginModule secureStorageLoginModule = this;
            synchronized (secureStorageLoginModule) {
                this.subject.getPrincipals().add(this.userPrincipal);
                this.subject.getPrincipals().addAll(this.userPrincipal.getRoles());
            }
            return true;
        }
        this.userPrincipal.destroy();
        this.userPrincipal = null;
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.userPrincipal.destroy();
        this.userPrincipal = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws LoginException {
        SecureStorageLoginModule secureStorageLoginModule = this;
        synchronized (secureStorageLoginModule) {
            this.subject.getPrincipals().remove(this.userPrincipal);
            this.subject.getPrincipals().removeAll(this.userPrincipal.getRoles());
        }
        this.subject = null;
        this.userPrincipal.destroy();
        this.userPrincipal = null;
        return true;
    }

    private UserPrincipal getUserInfo(String username) throws FailedLoginException {
        try {
            if (!SecureUserStore.existsUser(username)) {
                throw new FailedLoginException("Wrong credentials");
            }
            String password = SecureUserStore.getPassword(username);
            if (password == null) {
                throw new FailedLoginException("Corrupted user");
            }
            String roles = SecureUserStore.getRoles(username);
            if (roles == null) {
                roles = "";
            }
            UserPrincipal userPrincipal = new UserPrincipal(username, password);
            String[] stringArray = roles.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                userPrincipal.addRole(new RolePrincipal(role));
                ++n2;
            }
            return userPrincipal;
        }
        catch (Exception e) {
            throw new FailedLoginException(e.getMessage());
        }
    }
}

